/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.eql.action.EqlSearchResponse;
import org.elasticsearch.xpack.eql.execution.payload.AbstractPayload;
import org.elasticsearch.xpack.eql.execution.sequence.Sequence;
import org.elasticsearch.xpack.eql.session.Payload;

class SequencePayload
extends AbstractPayload {
    private final List<EqlSearchResponse.Sequence> values;

    SequencePayload(List<Sequence> sequences, List<List<SearchHit>> docs, boolean timedOut, TimeValue timeTook) {
        super(timedOut, timeTook);
        this.values = new ArrayList<EqlSearchResponse.Sequence>(sequences.size());
        for (int i = 0; i < sequences.size(); ++i) {
            Sequence s = sequences.get(i);
            List<SearchHit> hits = docs.get(i);
            ArrayList<EqlSearchResponse.Event> events = new ArrayList<EqlSearchResponse.Event>(hits.size());
            for (SearchHit hit : hits) {
                if (hit == null) {
                    events.add(EqlSearchResponse.Event.MISSING_EVENT);
                    continue;
                }
                events.add(new EqlSearchResponse.Event(hit));
            }
            this.values.add(new EqlSearchResponse.Sequence(s.key().asList(), events));
        }
    }

    @Override
    public Payload.Type resultType() {
        return Payload.Type.SEQUENCE;
    }

    public List<EqlSearchResponse.Sequence> values() {
        return this.values;
    }
}

