/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface.elser;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.ChunkingOptions;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.EmptySettingsConfiguration;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskSettingsConfiguration;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationDisplayType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.inference.results.ErrorChunkedInferenceResults;
import org.elasticsearch.xpack.core.inference.results.InferenceChunkedSparseEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.InferenceChunkedTextEmbeddingFloatResults;
import org.elasticsearch.xpack.core.inference.results.InferenceTextEmbeddingFloatResults;
import org.elasticsearch.xpack.core.inference.results.ResultUtils;
import org.elasticsearch.xpack.core.inference.results.SparseEmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.ErrorInferenceResults;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceBaseService;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceModel;
import org.elasticsearch.xpack.inference.services.huggingface.elser.HuggingFaceElserModel;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class HuggingFaceElserService
extends HuggingFaceBaseService {
    public static final String NAME = "hugging_face_elser";
    private static final EnumSet<TaskType> supportedTaskTypes = EnumSet.of(TaskType.SPARSE_EMBEDDING);

    public HuggingFaceElserService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents) {
        super(factory, serviceComponents);
    }

    public String name() {
        return NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected HuggingFaceModel createModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, ChunkingSettings chunkingSettings, @Nullable Map<String, Object> secretSettings, String failureMessage, ConfigurationParseContext context) {
        switch (taskType) {
            case SPARSE_EMBEDDING: {
                return new HuggingFaceElserModel(inferenceEntityId, taskType, NAME, serviceSettings, secretSettings, context);
            }
            default: {
                throw new ElasticsearchStatusException(failureMessage, RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
    }

    @Override
    protected void doChunkedInfer(Model model, DocumentsOnlyInput inputs, Map<String, Object> taskSettings, InputType inputType, ChunkingOptions chunkingOptions, TimeValue timeout, ActionListener<List<ChunkedInferenceServiceResults>> listener) {
        ActionListener inferListener = listener.delegateFailureAndWrap((delegate, response) -> delegate.onResponse(HuggingFaceElserService.translateToChunkedResults(inputs, response)));
        this.doInfer(model, inputs, taskSettings, inputType, timeout, (ActionListener<InferenceServiceResults>)inferListener);
    }

    private static List<ChunkedInferenceServiceResults> translateToChunkedResults(DocumentsOnlyInput inputs, InferenceServiceResults inferenceResults) {
        if (inferenceResults instanceof InferenceTextEmbeddingFloatResults) {
            InferenceTextEmbeddingFloatResults textEmbeddingResults = (InferenceTextEmbeddingFloatResults)inferenceResults;
            return InferenceChunkedTextEmbeddingFloatResults.listOf(inputs.getInputs(), (InferenceTextEmbeddingFloatResults)textEmbeddingResults);
        }
        if (inferenceResults instanceof SparseEmbeddingResults) {
            SparseEmbeddingResults sparseEmbeddingResults = (SparseEmbeddingResults)inferenceResults;
            return InferenceChunkedSparseEmbeddingResults.listOf(inputs.getInputs(), (SparseEmbeddingResults)sparseEmbeddingResults);
        }
        if (inferenceResults instanceof ErrorInferenceResults) {
            ErrorInferenceResults error = (ErrorInferenceResults)inferenceResults;
            return List.of(new ErrorChunkedInferenceResults(error.getException()));
        }
        String expectedClasses = Strings.format((String)"One of [%s,%s]", (Object[])new Object[]{InferenceTextEmbeddingFloatResults.class.getSimpleName(), SparseEmbeddingResults.class.getSimpleName()});
        throw ResultUtils.createInvalidChunkedResultException((String)expectedClasses, (String)inferenceResults.getWriteableName());
    }

    public InferenceServiceConfiguration getConfiguration() {
        return Configuration.get();
    }

    public Boolean hideFromConfigurationApi() {
        return Boolean.TRUE;
    }

    public EnumSet<TaskType> supportedTaskTypes() {
        return supportedTaskTypes;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_12_0;
    }

    public static class Configuration {
        private static final LazyInitializable<InferenceServiceConfiguration, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("url", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TEXTBOX).setLabel("URL").setOrder(Integer.valueOf(1)).setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setTooltip("The URL endpoint to use for the requests.").setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.putAll(DefaultSecretSettings.toSettingsConfiguration());
            configurationMap.putAll(RateLimitSettings.toSettingsConfiguration());
            return new InferenceServiceConfiguration.Builder().setProvider(HuggingFaceElserService.NAME).setTaskTypes(supportedTaskTypes.stream().map(t -> {
                switch (t) {
                    default: 
                }
                Map taskSettingsConfig = EmptySettingsConfiguration.get();
                return new TaskSettingsConfiguration.Builder().setTaskType(t).setConfiguration(taskSettingsConfig).build();
            }).toList()).setConfiguration(configurationMap).build();
        });

        public static InferenceServiceConfiguration get() {
            return (InferenceServiceConfiguration)configuration.getOrCompute();
        }
    }
}

