/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.EmptySecretSettings;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.elastic.ElasticInferenceServiceActionVisitor;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceComponents;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceModel;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSparseEmbeddingsServiceSettings;

public class ElasticInferenceServiceSparseEmbeddingsModel
extends ElasticInferenceServiceModel {
    private final URI uri;

    public ElasticInferenceServiceSparseEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, Map<String, Object> secrets, ElasticInferenceServiceComponents elasticInferenceServiceComponents, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, ElasticInferenceServiceSparseEmbeddingsServiceSettings.fromMap(serviceSettings, context), (TaskSettings)EmptyTaskSettings.INSTANCE, (SecretSettings)EmptySecretSettings.INSTANCE, elasticInferenceServiceComponents);
    }

    public ElasticInferenceServiceSparseEmbeddingsModel(ElasticInferenceServiceSparseEmbeddingsModel model, ElasticInferenceServiceSparseEmbeddingsServiceSettings serviceSettings) {
        super(model, serviceSettings);
        try {
            this.uri = this.createUri();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    ElasticInferenceServiceSparseEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, ElasticInferenceServiceSparseEmbeddingsServiceSettings serviceSettings, @Nullable TaskSettings taskSettings, @Nullable SecretSettings secretSettings, ElasticInferenceServiceComponents elasticInferenceServiceComponents) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, taskSettings), new ModelSecrets(secretSettings), serviceSettings, elasticInferenceServiceComponents);
        try {
            this.uri = this.createUri();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ExecutableAction accept(ElasticInferenceServiceActionVisitor visitor, Map<String, Object> taskSettings) {
        return visitor.create(this);
    }

    public ElasticInferenceServiceSparseEmbeddingsServiceSettings getServiceSettings() {
        return (ElasticInferenceServiceSparseEmbeddingsServiceSettings)super.getServiceSettings();
    }

    public URI uri() {
        return this.uri;
    }

    private URI createUri() throws URISyntaxException {
        String modelId;
        return new URI(this.elasticInferenceServiceComponents().eisGatewayUrl() + "/api/v1/sparse-text-embeddings/" + (switch (modelId = this.getServiceSettings().modelId()) {
            case ".elser_model_2" -> "ELSERv2";
            default -> throw new IllegalArgumentException("Unsupported model for EIS [" + modelId + "]");
        }));
    }
}

