/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.ChunkingOptions;
import org.elasticsearch.inference.EmptySettingsConfiguration;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskSettingsConfiguration;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationDisplayType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.inference.results.ErrorChunkedInferenceResults;
import org.elasticsearch.xpack.core.inference.results.InferenceChunkedSparseEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.ResultUtils;
import org.elasticsearch.xpack.core.inference.results.SparseEmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.ErrorInferenceResults;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.elastic.ElasticInferenceServiceActionCreator;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceComponents;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceModel;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSparseEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSparseEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class ElasticInferenceService
extends SenderService {
    public static final String NAME = "elastic";
    private final ElasticInferenceServiceComponents elasticInferenceServiceComponents;
    private static final EnumSet<TaskType> supportedTaskTypes = EnumSet.of(TaskType.SPARSE_EMBEDDING);

    public ElasticInferenceService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents, ElasticInferenceServiceComponents eisComponents) {
        super(factory, serviceComponents);
        this.elasticInferenceServiceComponents = eisComponents;
    }

    @Override
    protected void doInfer(Model model, InferenceInputs inputs, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!(model instanceof ElasticInferenceServiceModel)) {
            listener.onFailure((Exception)((Object)ServiceUtils.createInvalidModelException(model)));
            return;
        }
        ElasticInferenceServiceModel elasticInferenceServiceModel = (ElasticInferenceServiceModel)model;
        ElasticInferenceServiceActionCreator actionCreator = new ElasticInferenceServiceActionCreator(this.getSender(), this.getServiceComponents());
        ExecutableAction action = elasticInferenceServiceModel.accept(actionCreator, taskSettings);
        action.execute(inputs, timeout, listener);
    }

    @Override
    protected void doChunkedInfer(Model model, DocumentsOnlyInput inputs, Map<String, Object> taskSettings, InputType inputType, ChunkingOptions chunkingOptions, TimeValue timeout, ActionListener<List<ChunkedInferenceServiceResults>> listener) {
        ActionListener inferListener = listener.delegateFailureAndWrap((delegate, response) -> delegate.onResponse(ElasticInferenceService.translateToChunkedResults(inputs, response)));
        this.doInfer(model, inputs, taskSettings, inputType, timeout, (ActionListener<InferenceServiceResults>)inferListener);
    }

    public String name() {
        return NAME;
    }

    public void parseRequestConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config, ActionListener<Model> parsedModelListener) {
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
            ElasticInferenceServiceModel model = ElasticInferenceService.createModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, serviceSettingsMap, this.elasticInferenceServiceComponents, TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)NAME), ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(config, NAME);
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, NAME);
            ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, NAME);
            parsedModelListener.onResponse((Object)model);
        }
        catch (Exception e) {
            parsedModelListener.onFailure(e);
        }
    }

    public InferenceServiceConfiguration getConfiguration() {
        return Configuration.get();
    }

    public EnumSet<TaskType> supportedTaskTypes() {
        return supportedTaskTypes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ElasticInferenceServiceModel createModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secretSettings, ElasticInferenceServiceComponents eisServiceComponents, String failureMessage, ConfigurationParseContext context) {
        switch (taskType) {
            case SPARSE_EMBEDDING: {
                return new ElasticInferenceServiceSparseEmbeddingsModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, eisServiceComponents, context);
            }
            default: {
                throw new ElasticsearchStatusException(failureMessage, RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
    }

    public Model parsePersistedConfigWithSecrets(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(secrets, "secret_settings");
        return this.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, secretSettingsMap, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    public Model parsePersistedConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        return this.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, null, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_EIS_INTEGRATION_ADDED;
    }

    private ElasticInferenceServiceModel createModelFromPersistent(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secretSettings, String failureMessage) {
        return ElasticInferenceService.createModel(inferenceEntityId, taskType, serviceSettings, taskSettings, secretSettings, this.elasticInferenceServiceComponents, failureMessage, ConfigurationParseContext.PERSISTENT);
    }

    public void checkModelConfig(Model model, ActionListener<Model> listener) {
        if (model instanceof ElasticInferenceServiceSparseEmbeddingsModel) {
            ElasticInferenceServiceSparseEmbeddingsModel embeddingsModel = (ElasticInferenceServiceSparseEmbeddingsModel)model;
            listener.onResponse((Object)this.updateModelWithEmbeddingDetails(embeddingsModel));
        } else {
            listener.onResponse((Object)model);
        }
    }

    private static List<ChunkedInferenceServiceResults> translateToChunkedResults(InferenceInputs inputs, InferenceServiceResults inferenceResults) {
        if (inferenceResults instanceof SparseEmbeddingResults) {
            SparseEmbeddingResults sparseEmbeddingResults = (SparseEmbeddingResults)inferenceResults;
            return InferenceChunkedSparseEmbeddingResults.listOf(DocumentsOnlyInput.of(inputs).getInputs(), (SparseEmbeddingResults)sparseEmbeddingResults);
        }
        if (inferenceResults instanceof ErrorInferenceResults) {
            ErrorInferenceResults error = (ErrorInferenceResults)inferenceResults;
            return List.of(new ErrorChunkedInferenceResults(error.getException()));
        }
        String expectedClass = Strings.format((String)"%s", (Object[])new Object[]{SparseEmbeddingResults.class.getSimpleName()});
        throw ResultUtils.createInvalidChunkedResultException((String)expectedClass, (String)inferenceResults.getWriteableName());
    }

    private ElasticInferenceServiceSparseEmbeddingsModel updateModelWithEmbeddingDetails(ElasticInferenceServiceSparseEmbeddingsModel model) {
        ElasticInferenceServiceSparseEmbeddingsServiceSettings serviceSettings = new ElasticInferenceServiceSparseEmbeddingsServiceSettings(model.getServiceSettings().modelId(), model.getServiceSettings().maxInputTokens(), model.getServiceSettings().rateLimitSettings());
        return new ElasticInferenceServiceSparseEmbeddingsModel(model, serviceSettings);
    }

    public static class Configuration {
        private static final LazyInitializable<InferenceServiceConfiguration, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("model_id", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TEXTBOX).setLabel("Model ID").setOrder(Integer.valueOf(2)).setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setTooltip("The name of the model to use for the inference task.").setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("max_input_tokens", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.NUMERIC).setLabel("Maximum Input Tokens").setOrder(Integer.valueOf(3)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setTooltip("Allows you to specify the maximum number of tokens per input.").setType(SettingsConfigurationFieldType.INTEGER).build());
            configurationMap.putAll(RateLimitSettings.toSettingsConfiguration());
            return new InferenceServiceConfiguration.Builder().setProvider(ElasticInferenceService.NAME).setTaskTypes(supportedTaskTypes.stream().map(t -> {
                switch (t) {
                    default: 
                }
                Map taskSettingsConfig = EmptySettingsConfiguration.get();
                return new TaskSettingsConfiguration.Builder().setTaskType(t).setConfiguration(taskSettingsConfig).build();
            }).toList()).setConfiguration(configurationMap).build();
        });

        public static InferenceServiceConfiguration get() {
            return (InferenceServiceConfiguration)configuration.getOrCompute();
        }
    }
}

