/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureopenai;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.configuration.SettingsConfigurationDisplayType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class AzureOpenAiSecretSettings
implements SecretSettings {
    public static final String NAME = "azure_openai_secret_settings";
    public static final String API_KEY = "api_key";
    public static final String ENTRA_ID = "entra_id";
    private final SecureString entraId;
    private final SecureString apiKey;

    public static AzureOpenAiSecretSettings fromMap(@Nullable Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        ValidationException validationException = new ValidationException();
        SecureString secureApiToken = ServiceUtils.extractOptionalSecureString(map, API_KEY, "secret_settings", validationException);
        SecureString secureEntraId = ServiceUtils.extractOptionalSecureString(map, ENTRA_ID, "secret_settings", validationException);
        if (secureApiToken == null && secureEntraId == null) {
            validationException.addValidationError(Strings.format((String)"[secret_settings] must have either the [%s] or the [%s] key set", (Object[])new Object[]{API_KEY, ENTRA_ID}));
        }
        if (secureApiToken != null && secureEntraId != null) {
            validationException.addValidationError(Strings.format((String)"[secret_settings] must have only one of the [%s] or the [%s] key set", (Object[])new Object[]{API_KEY, ENTRA_ID}));
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AzureOpenAiSecretSettings(secureApiToken, secureEntraId);
    }

    public AzureOpenAiSecretSettings(@Nullable SecureString apiKey, @Nullable SecureString entraId) {
        Objects.requireNonNullElse(apiKey, entraId);
        this.apiKey = apiKey;
        this.entraId = entraId;
    }

    public AzureOpenAiSecretSettings(StreamInput in) throws IOException {
        this(in.readOptionalSecureString(), in.readOptionalSecureString());
    }

    public SecureString apiKey() {
        return this.apiKey;
    }

    public SecureString entraId() {
        return this.entraId;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.apiKey != null) {
            builder.field(API_KEY, this.apiKey.toString());
        }
        if (this.entraId != null) {
            builder.field(ENTRA_ID, this.entraId.toString());
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_14_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalSecureString(this.apiKey);
        out.writeOptionalSecureString(this.entraId);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AzureOpenAiSecretSettings that = (AzureOpenAiSecretSettings)object;
        return Objects.equals(this.entraId, that.entraId) && Objects.equals(this.apiKey, that.apiKey);
    }

    public int hashCode() {
        return Objects.hash(this.entraId, this.apiKey);
    }

    public SecretSettings newSecretSettings(Map<String, Object> newSecrets) {
        return AzureOpenAiSecretSettings.fromMap(new HashMap<String, Object>(newSecrets));
    }

    public static class Configuration {
        private static final LazyInitializable<Map<String, SettingsConfiguration>, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put(AzureOpenAiSecretSettings.API_KEY, new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TEXTBOX).setLabel("API Key").setOrder(Integer.valueOf(1)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(true)).setTooltip("You must provide either an API key or an Entra ID.").setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put(AzureOpenAiSecretSettings.ENTRA_ID, new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TEXTBOX).setLabel("Entra ID").setOrder(Integer.valueOf(2)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(true)).setTooltip("You must provide either an API key or an Entra ID.").setType(SettingsConfigurationFieldType.STRING).build());
            return Collections.unmodifiableMap(configurationMap);
        });

        public static Map<String, SettingsConfiguration> get() {
            return (Map)configuration.getOrCompute();
        }
    }
}

