/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rest;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;

abstract class BaseInferenceAction
extends BaseRestHandler {
    BaseInferenceAction() {
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        InferenceAction.Request.Builder requestBuilder;
        TaskType taskType;
        String inferenceEntityId;
        if (restRequest.hasParam("inference_id")) {
            inferenceEntityId = restRequest.param("inference_id");
            taskType = TaskType.fromStringOrStatusException((String)restRequest.param("task_type_or_id"));
        } else {
            inferenceEntityId = restRequest.param("task_type_or_id");
            taskType = TaskType.ANY;
        }
        try (XContentParser parser = restRequest.contentParser();){
            requestBuilder = InferenceAction.Request.parseRequest((String)inferenceEntityId, (TaskType)taskType, (XContentParser)parser);
        }
        TimeValue inferTimeout = restRequest.paramAsTime(InferenceAction.Request.TIMEOUT.getPreferredName(), InferenceAction.Request.DEFAULT_TIMEOUT);
        requestBuilder.setInferenceTimeout(inferTimeout);
        InferenceAction.Request request = this.prepareInferenceRequest(requestBuilder);
        return channel -> client.execute((ActionType)InferenceAction.INSTANCE, (ActionRequest)request, this.listener((RestChannel)channel));
    }

    protected InferenceAction.Request prepareInferenceRequest(InferenceAction.Request.Builder builder) {
        return builder.build();
    }

    protected abstract ActionListener<InferenceAction.Response> listener(RestChannel var1);
}

