/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rank.textsimilarity;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class TextSimilarityRankDoc
extends RankDoc {
    public static final String NAME = "text_similarity_rank_doc";
    public final String inferenceId;
    public final String field;

    public TextSimilarityRankDoc(int doc, float score, int shardIndex, String inferenceId, String field) {
        super(doc, score, shardIndex);
        this.inferenceId = inferenceId;
        this.field = field;
    }

    public TextSimilarityRankDoc(StreamInput in) throws IOException {
        super(in);
        this.inferenceId = in.readString();
        this.field = in.readString();
    }

    public Explanation explain(Explanation[] sources, String[] queryNames) {
        String queryAlias = queryNames[0] == null ? "" : "[" + queryNames[0] + "]";
        return Explanation.match((Number)Float.valueOf(this.score), (String)("text_similarity_reranker match using inference endpoint: [" + this.inferenceId + "] on document field: [" + this.field + "] matching on source query " + queryAlias), (Explanation[])sources);
    }

    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.inferenceId);
        out.writeString(this.field);
    }

    public boolean doEquals(RankDoc rd) {
        TextSimilarityRankDoc tsrd = (TextSimilarityRankDoc)rd;
        return Objects.equals(this.inferenceId, tsrd.inferenceId) && Objects.equals(this.field, tsrd.field);
    }

    public int doHashCode() {
        return Objects.hash(this.inferenceId, this.field);
    }

    public String toString() {
        return "TextSimilarityRankDoc{doc=" + this.doc + ", shardIndex=" + this.shardIndex + ", score=" + this.score + ", inferenceId=" + this.inferenceId + ", field=" + this.field + "}";
    }

    public String getWriteableName() {
        return NAME;
    }

    protected void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("inferenceId", this.inferenceId);
        builder.field("field", this.field);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.TEXT_SIMILARITY_RERANKER_QUERY_REWRITE;
    }
}

