/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.elastic;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorMessage;

public class ElasticInferenceServiceErrorResponseEntity
implements ErrorMessage {
    private final String errorMessage;
    private static final Logger logger = LogManager.getLogger(ElasticInferenceServiceErrorResponseEntity.class);

    private ElasticInferenceServiceErrorResponseEntity(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ElasticInferenceServiceErrorResponseEntity fromResponse(HttpResult response) {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body());){
            Map responseMap = jsonParser.map();
            String error = (String)responseMap.get("error");
            if (error == null) return null;
            ElasticInferenceServiceErrorResponseEntity elasticInferenceServiceErrorResponseEntity = new ElasticInferenceServiceErrorResponseEntity(error);
            return elasticInferenceServiceErrorResponseEntity;
        }
        catch (Exception e) {
            logger.debug("Failed to parse error response", (Throwable)e);
        }
        return null;
    }
}

