/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.azureaistudio;

import java.net.URI;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioEndpointType;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioModel;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioProvider;

public abstract class AzureAiStudioRequest
implements Request {
    protected final URI uri;
    protected final String inferenceEntityId;
    protected final boolean isOpenAiRequest;
    protected final boolean isRealtimeEndpoint;

    protected AzureAiStudioRequest(AzureAiStudioModel model) {
        this.uri = model.uri();
        this.inferenceEntityId = model.getInferenceEntityId();
        this.isOpenAiRequest = model.provider() == AzureAiStudioProvider.OPENAI;
        this.isRealtimeEndpoint = model.endpointType() == AzureAiStudioEndpointType.REALTIME;
    }

    protected void setAuthHeader(HttpEntityEnclosingRequestBase request, AzureAiStudioModel model) {
        SecureString apiKey = model.getSecretSettings().apiKey();
        if (this.isOpenAiRequest) {
            request.setHeader("api-key", apiKey.toString());
        } else if (this.isRealtimeEndpoint) {
            request.setHeader(RequestUtils.createAuthBearerHeader(apiKey));
        } else {
            request.setHeader("Authorization", apiKey.toString());
        }
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getInferenceEntityId() {
        return this.inferenceEntityId;
    }
}

