/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.amazonbedrock;

import java.time.Clock;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockClient;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockSecretSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockServiceSettings;

public abstract class AmazonBedrockBaseClient
implements AmazonBedrockClient {
    protected final Integer modelKeysAndRegionHashcode;
    protected Clock clock = Clock.systemUTC();

    protected AmazonBedrockBaseClient(AmazonBedrockModel model, @Nullable TimeValue timeout) {
        Objects.requireNonNull(model);
        this.modelKeysAndRegionHashcode = AmazonBedrockBaseClient.getModelKeysAndRegionHashcode(model, timeout);
    }

    public static Integer getModelKeysAndRegionHashcode(AmazonBedrockModel model, @Nullable TimeValue timeout) {
        AmazonBedrockSecretSettings secretSettings = model.getSecretSettings();
        AmazonBedrockServiceSettings serviceSettings = model.getServiceSettings();
        return Objects.hash(secretSettings.accessKey, secretSettings.secretKey, serviceSettings.region(), timeout);
    }

    public final void setClock(Clock clock) {
        this.clock = clock;
    }

    abstract void close();
}

