/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.mistral;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.mistral.MistralActionVisitor;
import org.elasticsearch.xpack.inference.external.http.sender.MistralEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.mistral.embeddings.MistralEmbeddingsModel;

public class MistralActionCreator
implements MistralActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public MistralActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(MistralEmbeddingsModel embeddingsModel, Map<String, Object> taskSettings) {
        MistralEmbeddingsRequestManager requestManager = new MistralEmbeddingsRequestManager(embeddingsModel, this.serviceComponents.truncator(), this.serviceComponents.threadPool());
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage(embeddingsModel.uri(), "Mistral embeddings");
        return new SenderExecutableAction(this.sender, requestManager, errorMessage);
    }
}

