/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.cohere;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SingleInputSenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.cohere.CohereActionVisitor;
import org.elasticsearch.xpack.inference.external.http.sender.CohereCompletionRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.CohereEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.CohereRerankRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.cohere.completion.CohereCompletionModel;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.cohere.rerank.CohereRerankModel;

public class CohereActionCreator
implements CohereActionVisitor {
    private static final String COMPLETION_ERROR_PREFIX = "Cohere completion";
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public CohereActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(CohereEmbeddingsModel model, Map<String, Object> taskSettings, InputType inputType) {
        CohereEmbeddingsModel overriddenModel = CohereEmbeddingsModel.of(model, taskSettings, inputType);
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage(overriddenModel.getServiceSettings().getCommonSettings().uri(), "Cohere embeddings");
        CohereEmbeddingsRequestManager requestCreator = CohereEmbeddingsRequestManager.of(overriddenModel, this.serviceComponents.threadPool());
        return new SenderExecutableAction(this.sender, requestCreator, failedToSendRequestErrorMessage);
    }

    @Override
    public ExecutableAction create(CohereRerankModel model, Map<String, Object> taskSettings) {
        CohereRerankModel overriddenModel = CohereRerankModel.of(model, taskSettings);
        CohereRerankRequestManager requestCreator = CohereRerankRequestManager.of(overriddenModel, this.serviceComponents.threadPool());
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage(overriddenModel.getServiceSettings().uri(), "Cohere rerank");
        return new SenderExecutableAction(this.sender, requestCreator, failedToSendRequestErrorMessage);
    }

    @Override
    public ExecutableAction create(CohereCompletionModel model, Map<String, Object> taskSettings) {
        CohereCompletionRequestManager requestManager = CohereCompletionRequestManager.of(model, this.serviceComponents.threadPool());
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage(model.getServiceSettings().uri(), COMPLETION_ERROR_PREFIX);
        return new SingleInputSenderExecutableAction(this.sender, requestManager, failedToSendRequestErrorMessage, COMPLETION_ERROR_PREFIX);
    }
}

