/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.h3;

import java.util.Arrays;
import org.elasticsearch.h3.BaseCells;
import org.elasticsearch.h3.CellBoundary;
import org.elasticsearch.h3.Constants;
import org.elasticsearch.h3.CoordIJK;
import org.elasticsearch.h3.FaceIJK;
import org.elasticsearch.h3.H3Index;
import org.elasticsearch.h3.HexRing;
import org.elasticsearch.h3.LatLng;
import org.elasticsearch.h3.Vec3d;

public final class H3 {
    public static int MAX_H3_RES = 15;
    private static final long[] NORTH = new long[MAX_H3_RES + 1];
    private static final long[] SOUTH = new long[MAX_H3_RES + 1];
    private static final int[] PEN_INTERSECTING_CHILDREN_DIRECTIONS;
    private static final int[] HEX_INTERSECTING_CHILDREN_DIRECTIONS;

    public static String h3ToString(long h3) {
        return Long.toHexString(h3);
    }

    public static long stringToH3(String h3Address) {
        return Long.parseUnsignedLong(h3Address, 16);
    }

    public static int getResolution(long h3) {
        return H3Index.H3_get_resolution(h3);
    }

    public static int getResolution(String h3Address) {
        return H3.getResolution(H3.stringToH3(h3Address));
    }

    public static boolean isPentagon(long h3) {
        return H3Index.H3_is_pentagon(h3);
    }

    public static boolean isPentagon(String h3Address) {
        return H3.isPentagon(H3.stringToH3(h3Address));
    }

    public static boolean h3IsValid(long h3) {
        int digit;
        int r;
        if (H3Index.H3_get_high_bit(h3) != 0) {
            return false;
        }
        if (H3Index.H3_get_mode(h3) != Constants.H3_CELL_MODE) {
            return false;
        }
        if (H3Index.H3_get_reserved_bits(h3) != 0) {
            return false;
        }
        int baseCell = H3Index.H3_get_base_cell(h3);
        if (baseCell < 0 || baseCell >= Constants.NUM_BASE_CELLS) {
            return false;
        }
        int res = H3Index.H3_get_resolution(h3);
        if (res < 0 || res > MAX_H3_RES) {
            return false;
        }
        boolean foundFirstNonZeroDigit = false;
        for (r = 1; r <= res; ++r) {
            digit = H3Index.H3_get_index_digit(h3, r);
            if (!foundFirstNonZeroDigit && digit != CoordIJK.Direction.CENTER_DIGIT.digit()) {
                foundFirstNonZeroDigit = true;
                if (BaseCells.isBaseCellPentagon(baseCell) && digit == CoordIJK.Direction.K_AXES_DIGIT.digit()) {
                    return false;
                }
            }
            if (digit >= CoordIJK.Direction.CENTER_DIGIT.digit() && digit < CoordIJK.Direction.NUM_DIGITS.digit()) continue;
            return false;
        }
        for (r = res + 1; r <= MAX_H3_RES; ++r) {
            digit = H3Index.H3_get_index_digit(h3, r);
            if (digit == CoordIJK.Direction.INVALID_DIGIT.digit()) continue;
            return false;
        }
        return true;
    }

    public static boolean h3IsValid(String h3Address) {
        return H3.h3IsValid(H3.stringToH3(h3Address));
    }

    public static long[] getLongRes0Cells() {
        long[] cells = new long[Constants.NUM_BASE_CELLS];
        for (int bc = 0; bc < Constants.NUM_BASE_CELLS; ++bc) {
            long baseCell = H3Index.H3_INIT;
            baseCell = H3Index.H3_set_mode(baseCell, Constants.H3_CELL_MODE);
            cells[bc] = baseCell = H3Index.H3_set_base_cell(baseCell, bc);
        }
        return cells;
    }

    public static String[] getStringRes0Cells() {
        return H3.h3ToStringList(H3.getLongRes0Cells());
    }

    public static LatLng h3ToLatLng(long h3) {
        FaceIJK fijk = H3Index.h3ToFaceIjk(h3);
        return fijk.faceIjkToGeo(H3Index.H3_get_resolution(h3));
    }

    public static LatLng h3ToLatLng(String h3Address) {
        return H3.h3ToLatLng(H3.stringToH3(h3Address));
    }

    public static CellBoundary h3ToGeoBoundary(long h3) {
        FaceIJK fijk = H3Index.h3ToFaceIjk(h3);
        if (H3Index.H3_is_pentagon(h3)) {
            return fijk.faceIjkPentToCellBoundary(H3Index.H3_get_resolution(h3), 0, Constants.NUM_PENT_VERTS);
        }
        return fijk.faceIjkToCellBoundary(H3Index.H3_get_resolution(h3), 0, Constants.NUM_HEX_VERTS);
    }

    public static CellBoundary h3ToGeoBoundary(String h3Address) {
        return H3.h3ToGeoBoundary(H3.stringToH3(h3Address));
    }

    public static long geoToH3(double lat, double lng, int res) {
        H3.checkResolution(res);
        return Vec3d.geoToH3(res, Math.toRadians(lat), Math.toRadians(lng));
    }

    public static String geoToH3Address(double lat, double lng, int res) {
        return H3.h3ToString(H3.geoToH3(lat, lng, res));
    }

    public static long h3ToParent(long h3) {
        int childRes = H3Index.H3_get_resolution(h3);
        if (childRes == 0) {
            throw new IllegalArgumentException("Input is a base cell");
        }
        long parentH = H3Index.H3_set_resolution(h3, childRes - 1);
        return H3Index.H3_set_index_digit(parentH, childRes, H3Index.H3_DIGIT_MASK);
    }

    public static String h3ToParent(String h3Address) {
        long parent = H3.h3ToParent(H3.stringToH3(h3Address));
        return H3.h3ToString(parent);
    }

    public static long[] h3ToChildren(long h3) {
        long[] children = new long[H3.h3ToChildrenSize(h3)];
        for (int i = 0; i < children.length; ++i) {
            children[i] = H3.childPosToH3(h3, i);
        }
        return children;
    }

    public static String[] h3ToChildren(String h3Address) {
        return H3.h3ToStringList(H3.h3ToChildren(H3.stringToH3(h3Address)));
    }

    public static long childPosToH3(long h3, int childPos) {
        int maxPos;
        int childrenRes = H3Index.H3_get_resolution(h3) + 1;
        if (childrenRes > MAX_H3_RES) {
            throw new IllegalArgumentException("Resolution overflow");
        }
        long childH = H3Index.H3_set_resolution(h3, childrenRes);
        if (childPos == 0) {
            return H3Index.H3_set_index_digit(childH, childrenRes, CoordIJK.Direction.CENTER_DIGIT.digit());
        }
        boolean isPentagon = H3.isPentagon(h3);
        int n = maxPos = isPentagon ? 5 : 6;
        if (childPos < 0 || childPos > maxPos) {
            throw new IllegalArgumentException("invalid child position");
        }
        if (isPentagon) {
            return H3Index.H3_set_index_digit(childH, childrenRes, childPos + 1);
        }
        return H3Index.H3_set_index_digit(childH, childrenRes, childPos);
    }

    public static String childPosToH3(String h3Address, int childPos) {
        return H3.h3ToString(H3.childPosToH3(H3.stringToH3(h3Address), childPos));
    }

    public static long[] h3ToNoChildrenIntersecting(long h3) {
        boolean isPentagon = H3.isPentagon(h3);
        long[] noChildren = new long[isPentagon ? 5 : 6];
        for (int i = 0; i < noChildren.length; ++i) {
            noChildren[i] = H3.noChildIntersectingPosToH3(h3, i);
        }
        return noChildren;
    }

    public static String[] h3ToNoChildrenIntersecting(String h3Address) {
        return H3.h3ToStringList(H3.h3ToNoChildrenIntersecting(H3.stringToH3(h3Address)));
    }

    public static long noChildIntersectingPosToH3(long h3, int childPos) {
        int maxPos;
        int childrenRes = H3Index.H3_get_resolution(h3) + 1;
        if (childrenRes > MAX_H3_RES) {
            throw new IllegalArgumentException("Resolution overflow");
        }
        boolean isPentagon = H3.isPentagon(h3);
        int n = maxPos = isPentagon ? 4 : 5;
        if (childPos < 0 || childPos > maxPos) {
            throw new IllegalArgumentException("invalid child position");
        }
        long childH = H3Index.H3_set_resolution(h3, childrenRes);
        if (isPentagon) {
            long child = H3Index.H3_set_index_digit(childH, childrenRes, childPos + 2);
            return HexRing.h3NeighborInDirection(child, PEN_INTERSECTING_CHILDREN_DIRECTIONS[childPos]);
        }
        long child = H3Index.H3_set_index_digit(childH, childrenRes, childPos + 1);
        return HexRing.h3NeighborInDirection(child, HEX_INTERSECTING_CHILDREN_DIRECTIONS[childPos]);
    }

    public static String noChildIntersectingPosToH3(String h3Address, int childPos) {
        return H3.h3ToString(H3.noChildIntersectingPosToH3(H3.stringToH3(h3Address), childPos));
    }

    public static String[] hexRing(String h3Address) {
        return H3.h3ToStringList(H3.hexRing(H3.stringToH3(h3Address)));
    }

    public static long[] hexRing(long h3) {
        long[] ring = new long[H3.hexRingSize(h3)];
        for (int i = 0; i < ring.length; ++i) {
            ring[i] = H3.hexRingPosToH3(h3, i);
            assert (ring[i] >= 0L);
        }
        return ring;
    }

    public static int hexRingSize(long h3) {
        return H3Index.H3_is_pentagon(h3) ? 5 : 6;
    }

    public static int hexRingSize(String h3Address) {
        return H3.hexRingSize(H3.stringToH3(h3Address));
    }

    public static long hexRingPosToH3(long h3, int ringPos) {
        int pos;
        int n = pos = H3Index.H3_is_pentagon(h3) && ringPos >= 2 ? ringPos + 1 : ringPos;
        if (pos < 0 || pos > 5) {
            throw new IllegalArgumentException("invalid ring position");
        }
        return HexRing.h3NeighborInDirection(h3, HexRing.DIRECTIONS[pos].digit());
    }

    public static String hexRingPosToH3(String h3Address, int ringPos) {
        return H3.h3ToString(H3.hexRingPosToH3(H3.stringToH3(h3Address), ringPos));
    }

    public static boolean areNeighborCells(String origin, String destination) {
        return H3.areNeighborCells(H3.stringToH3(origin), H3.stringToH3(destination));
    }

    public static boolean areNeighborCells(long origin, long destination) {
        return HexRing.areNeighbours(origin, destination);
    }

    public static long h3ToChildrenSize(long h3, int childRes) {
        int parentRes = H3Index.H3_get_resolution(h3);
        if (childRes <= parentRes || childRes > MAX_H3_RES) {
            throw new IllegalArgumentException("Invalid child resolution [" + childRes + "]");
        }
        int n = childRes - parentRes;
        if (H3Index.H3_is_pentagon(h3)) {
            return 1L + 5L * (H3._ipow(7, n) - 1L) / 6L;
        }
        return H3._ipow(7, n);
    }

    public static long h3ToChildrenSize(String h3Address, int childRes) {
        return H3.h3ToChildrenSize(H3.stringToH3(h3Address), childRes);
    }

    public static int h3ToChildrenSize(long h3) {
        if (H3Index.H3_get_resolution(h3) == MAX_H3_RES) {
            throw new IllegalArgumentException("Invalid child resolution [" + MAX_H3_RES + "]");
        }
        return H3.isPentagon(h3) ? 6 : 7;
    }

    public static int h3ToChildrenSize(String h3Address) {
        return H3.h3ToChildrenSize(H3.stringToH3(h3Address));
    }

    public static int h3ToNotIntersectingChildrenSize(long h3) {
        if (H3Index.H3_get_resolution(h3) == MAX_H3_RES) {
            throw new IllegalArgumentException("Invalid child resolution [" + MAX_H3_RES + "]");
        }
        return H3.isPentagon(h3) ? 5 : 6;
    }

    public static int h3ToNotIntersectingChildrenSize(String h3Address) {
        return H3.h3ToNotIntersectingChildrenSize(H3.stringToH3(h3Address));
    }

    public static long northPolarH3(int res) {
        H3.checkResolution(res);
        return NORTH[res];
    }

    public static String northPolarH3Address(int res) {
        return H3.h3ToString(H3.northPolarH3(res));
    }

    public static long southPolarH3(int res) {
        H3.checkResolution(res);
        return SOUTH[res];
    }

    public static String southPolarH3Address(int res) {
        return H3.h3ToString(H3.southPolarH3(res));
    }

    private static long _ipow(int base, int exp) {
        long result = 1L;
        while (exp != 0) {
            if ((exp & 1) != 0) {
                result *= (long)base;
            }
            exp >>= 1;
            base *= base;
        }
        return result;
    }

    private static String[] h3ToStringList(long[] h3s) {
        return (String[])Arrays.stream(h3s).mapToObj(H3::h3ToString).toArray(String[]::new);
    }

    private static void checkResolution(int res) {
        if (res < 0 || res > MAX_H3_RES) {
            throw new IllegalArgumentException("resolution [" + res + "]  is out of range (must be 0 <= res <= 15)");
        }
    }

    static {
        for (int res = 0; res <= MAX_H3_RES; ++res) {
            H3.NORTH[res] = H3.geoToH3(90.0, 0.0, res);
            H3.SOUTH[res] = H3.geoToH3(-90.0, 0.0, res);
        }
        PEN_INTERSECTING_CHILDREN_DIRECTIONS = new int[]{3, 1, 6, 4, 2};
        HEX_INTERSECTING_CHILDREN_DIRECTIONS = new int[]{3, 6, 2, 5, 1, 4};
    }
}

