/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.snapshot.upgrader;

import java.util.Optional;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeState;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskParams;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.task.OpenJobPersistentTasksExecutor;

public class SnapshotUpgradePredicate
implements Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> {
    private final boolean waitForCompletion;
    private final Logger logger;
    private volatile Exception exception;
    private volatile String node = "";
    private volatile boolean shouldCancel;
    private volatile boolean isCompleted;

    public SnapshotUpgradePredicate(boolean waitForCompletion, Logger logger) {
        this.waitForCompletion = waitForCompletion;
        this.logger = logger;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getNode() {
        return this.node;
    }

    public boolean isShouldCancel() {
        return this.shouldCancel;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    @Override
    public boolean test(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
        SnapshotUpgradeTaskParams params;
        if (persistentTask == null) {
            this.isCompleted = true;
            return true;
        }
        SnapshotUpgradeTaskState snapshotUpgradeTaskState = (SnapshotUpgradeTaskState)persistentTask.getState();
        SnapshotUpgradeState snapshotUpgradeState = snapshotUpgradeTaskState == null ? SnapshotUpgradeState.STOPPED : snapshotUpgradeTaskState.getState();
        String reason = snapshotUpgradeTaskState == null ? "" : snapshotUpgradeTaskState.getReason();
        PersistentTasksCustomMetadata.Assignment assignment = persistentTask.getAssignment();
        Optional<ElasticsearchException> assignmentException = OpenJobPersistentTasksExecutor.checkAssignmentState(assignment, (params = (SnapshotUpgradeTaskParams)persistentTask.getParams()).getJobId(), this.logger);
        if (assignmentException.isPresent()) {
            this.exception = (Exception)assignmentException.get();
            this.shouldCancel = true;
            return true;
        }
        if (snapshotUpgradeState == SnapshotUpgradeState.FAILED) {
            this.exception = ExceptionsHelper.serverError((String)("Unexpected state [" + String.valueOf(snapshotUpgradeState) + "] while waiting for to be assigned to a node; recorded reason [" + reason + "]"));
            this.shouldCancel = true;
            return true;
        }
        if (persistentTask.getExecutorNode() != null) {
            this.node = persistentTask.getExecutorNode();
            return !this.waitForCompletion;
        }
        return false;
    }
}

