/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.chunked;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.core.ml.datafeed.SearchInterval;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.chunked.ChunkedDataExtractorContext;

public class ChunkedDataExtractor
implements DataExtractor {
    private static final Logger LOGGER = LogManager.getLogger(ChunkedDataExtractor.class);
    private static final long MIN_CHUNK_SPAN = 60000L;
    private final DataExtractorFactory dataExtractorFactory;
    private final ChunkedDataExtractorContext context;
    private long currentStart;
    private long currentEnd;
    private long chunkSpan;
    private boolean isCancelled;
    private DataExtractor currentExtractor;

    public ChunkedDataExtractor(DataExtractorFactory dataExtractorFactory, ChunkedDataExtractorContext context) {
        this.dataExtractorFactory = Objects.requireNonNull(dataExtractorFactory);
        this.context = Objects.requireNonNull(context);
        this.currentStart = context.start();
        this.currentEnd = context.start();
        this.isCancelled = false;
    }

    @Override
    public DataExtractor.DataSummary getSummary() {
        return null;
    }

    @Override
    public boolean hasNext() {
        boolean currentHasNext;
        boolean bl = currentHasNext = this.currentExtractor != null && this.currentExtractor.hasNext();
        if (this.isCancelled()) {
            return currentHasNext;
        }
        return currentHasNext || this.currentEnd < this.context.end();
    }

    @Override
    public DataExtractor.Result next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.currentExtractor == null) {
            this.setUpChunkedSearch();
        }
        return this.getNextStream();
    }

    private void setUpChunkedSearch() {
        DataExtractor.DataSummary dataSummary = this.dataExtractorFactory.newExtractor(this.currentStart, this.context.end()).getSummary();
        if (dataSummary.hasData()) {
            long timeSpread;
            this.currentEnd = this.currentStart = this.context.timeAligner().alignToFloor(dataSummary.earliestTime());
            this.chunkSpan = this.context.chunkSpan() != null ? this.context.chunkSpan().getMillis() : (this.context.hasAggregations() ? 1000L * this.context.histogramInterval() : ((timeSpread = dataSummary.latestTime() - dataSummary.earliestTime()) <= 0L ? this.context.end() - this.currentEnd : Math.max(60000L, 10L * ((long)this.context.scrollSize() * timeSpread) / dataSummary.totalHits())));
            this.chunkSpan = this.context.timeAligner().alignToCeil(this.chunkSpan);
            LOGGER.debug("[{}] Chunked search configured: chunk span = {} ms", (Object)this.context.jobId(), (Object)this.chunkSpan);
        } else {
            this.currentEnd = this.context.end();
            LOGGER.debug("[{}] Chunked search configured: no data found", (Object)this.context.jobId());
        }
    }

    private DataExtractor.Result getNextStream() throws IOException {
        SearchInterval lastSearchInterval = new SearchInterval(this.context.start(), this.context.end());
        while (this.hasNext()) {
            boolean isNewSearch = false;
            if (this.currentExtractor == null || !this.currentExtractor.hasNext()) {
                this.advanceTime();
                isNewSearch = true;
            }
            DataExtractor.Result result = this.currentExtractor.next();
            lastSearchInterval = result.searchInterval();
            if (result.data().isPresent()) {
                return result;
            }
            if (!isNewSearch || !this.hasNext()) continue;
            this.currentStart += this.chunkSpan;
            this.setUpChunkedSearch();
        }
        return new DataExtractor.Result(lastSearchInterval, Optional.empty());
    }

    private void advanceTime() {
        this.currentStart = this.currentEnd;
        this.currentEnd = Math.min(this.currentStart + this.chunkSpan, this.context.end());
        this.currentExtractor = this.dataExtractorFactory.newExtractor(this.currentStart, this.currentEnd);
        LOGGER.debug("[{}] advances time to [{}, {})", (Object)this.context.jobId(), (Object)this.currentStart, (Object)this.currentEnd);
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void cancel() {
        if (this.currentExtractor != null) {
            this.currentExtractor.cancel();
        }
        this.isCancelled = true;
    }

    @Override
    public void destroy() {
        this.cancel();
        if (this.currentExtractor != null) {
            this.currentExtractor.destroy();
        }
    }

    @Override
    public long getEndTime() {
        return this.context.end();
    }

    ChunkedDataExtractorContext getContext() {
        return this.context;
    }
}

