/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetMlAutoscalingStats;
import org.elasticsearch.xpack.core.ml.autoscaling.MlAutoscalingStats;
import org.elasticsearch.xpack.ml.autoscaling.MlAutoscalingResourceTracker;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class TransportGetMlAutoscalingStats
extends TransportMasterNodeAction<GetMlAutoscalingStats.Request, GetMlAutoscalingStats.Response> {
    private final MlMemoryTracker mlMemoryTracker;
    private final Settings settings;

    @Inject
    public TransportGetMlAutoscalingStats(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Settings settings, MlMemoryTracker mlMemoryTracker) {
        super("cluster:monitor/xpack/ml/autoscaling/stats/get", transportService, clusterService, threadPool, actionFilters, GetMlAutoscalingStats.Request::new, indexNameExpressionResolver, GetMlAutoscalingStats.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.mlMemoryTracker = mlMemoryTracker;
        this.settings = settings;
    }

    protected void masterOperation(Task task, GetMlAutoscalingStats.Request request, ClusterState state, ActionListener<GetMlAutoscalingStats.Response> listener) {
        if (!this.mlMemoryTracker.isRecentlyRefreshed()) {
            this.mlMemoryTracker.asyncRefresh();
        }
        MlAutoscalingResourceTracker.getMlAutoscalingStats(state, this.clusterService.getClusterSettings(), this.mlMemoryTracker, this.settings, (ActionListener<MlAutoscalingStats>)listener.delegateFailureAndWrap((l, autoscalingResources) -> l.onResponse((Object)new GetMlAutoscalingStats.Response(autoscalingResources))));
    }

    protected ClusterBlockException checkBlock(GetMlAutoscalingStats.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

