/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.rest;

import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.datastreams.GetDataStreamAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetDataStreamsAction
extends BaseRestHandler {
    private static final Set<String> SUPPORTED_QUERY_PARAMETERS = Set.copyOf(Sets.union((Set)RestRequest.INTERNAL_MARKER_REQUEST_PARAMETERS, (Set[])new Set[]{Set.of("name", "include_defaults", "master_timeout", "expand_wildcards", "ignore_unavailable", "allow_no_indices", "ignore_throttled", "verbose"), DataStream.isFailureStoreFeatureFlagEnabled() ? Set.of("failure_store") : Set.of()}));

    public String getName() {
        return "get_data_streams_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_data_stream"), new RestHandler.Route(RestRequest.Method.GET, "/_data_stream/{name}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        GetDataStreamAction.Request getDataStreamsRequest = new GetDataStreamAction.Request(RestUtils.getMasterNodeTimeout((RestRequest)request), Strings.splitStringByCommaToArray((String)request.param("name")));
        getDataStreamsRequest.includeDefaults(request.paramAsBoolean("include_defaults", false));
        getDataStreamsRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)getDataStreamsRequest.indicesOptions()));
        getDataStreamsRequest.verbose(request.paramAsBoolean("verbose", false));
        return channel -> client.execute((ActionType)GetDataStreamAction.INSTANCE, (ActionRequest)getDataStreamsRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    public Set<String> supportedCapabilities() {
        return Set.of("data_stream_lifecycle_effective_retention");
    }

    public Set<String> supportedQueryParameters() {
        return SUPPORTED_QUERY_PARAMETERS;
    }
}

