/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.options.action;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.DataStreamsActionUtil;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.datastreams.options.action.GetDataStreamOptionsAction;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetDataStreamOptionsAction
extends TransportMasterNodeReadAction<GetDataStreamOptionsAction.Request, GetDataStreamOptionsAction.Response> {
    private final SystemIndices systemIndices;

    @Inject
    public TransportGetDataStreamOptionsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices) {
        super(GetDataStreamOptionsAction.INSTANCE.name(), transportService, clusterService, threadPool, actionFilters, GetDataStreamOptionsAction.Request::new, indexNameExpressionResolver, GetDataStreamOptionsAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.systemIndices = systemIndices;
    }

    protected void masterOperation(Task task, GetDataStreamOptionsAction.Request request, ClusterState state, ActionListener<GetDataStreamOptionsAction.Response> listener) {
        List requestedDataStreams = DataStreamsActionUtil.getDataStreamNames((IndexNameExpressionResolver)this.indexNameExpressionResolver, (ClusterState)state, (String[])request.getNames(), (IndicesOptions)request.indicesOptions());
        Map dataStreams = state.metadata().dataStreams();
        for (String name : requestedDataStreams) {
            this.systemIndices.validateDataStreamAccess(name, this.threadPool.getThreadContext());
        }
        listener.onResponse((Object)new GetDataStreamOptionsAction.Response(requestedDataStreams.stream().map(dataStreams::get).filter(Objects::nonNull).map(dataStream -> new GetDataStreamOptionsAction.Response.DataStreamEntry(dataStream.getName(), dataStream.getDataStreamOptions())).sorted(Comparator.comparing(GetDataStreamOptionsAction.Response.DataStreamEntry::dataStreamName)).toList()));
    }

    protected ClusterBlockException checkBlock(GetDataStreamOptionsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

