/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.ConditionalFunction;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.NullIfPipe;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.NullIfProcessor;

public class NullIf
extends ConditionalFunction {
    private final Expression left;
    private final Expression right;

    public NullIf(Source source, Expression left, Expression right) {
        super(source, Arrays.asList(left, right));
        this.left = left;
        this.right = right;
    }

    protected NodeInfo<? extends NullIf> info() {
        return NodeInfo.create((Node)this, NullIf::new, (Object)((Expression)this.children().get(0)), (Object)((Expression)this.children().get(1)));
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new NullIf(this.source(), newChildren.get(0), newChildren.get(1));
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    @Override
    public boolean foldable() {
        return this.left.semanticEquals(this.right) || super.foldable();
    }

    public Object fold() {
        if (this.left.semanticEquals(this.right)) {
            return null;
        }
        return NullIfProcessor.apply(this.left.fold(), this.right.fold());
    }

    public ScriptTemplate asScript() {
        ScriptTemplate left = this.asScript((Expression)this.children().get(0));
        ScriptTemplate right = this.asScript((Expression)this.children().get(1));
        String template = "{sql}.nullif(" + left.template() + "," + right.template() + ")";
        ParamsBuilder params = ParamsBuilder.paramsBuilder();
        params.script(left.params());
        params.script(right.params());
        return new ScriptTemplate(this.formatTemplate(template), params.build(), this.dataType);
    }

    protected Pipe makePipe() {
        return new NullIfPipe(this.source(), (Expression)this, Expressions.pipe((Expression)((Expression)this.children().get(0))), Expressions.pipe((Expression)((Expression)this.children().get(1))));
    }
}

