/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.ilm.IndexLifecycleClusterStateUpdateTask;
import org.elasticsearch.xpack.ilm.IndexLifecycleTransition;
import org.elasticsearch.xpack.ilm.PolicyStepsRegistry;

public class MoveToNextStepUpdateTask
extends IndexLifecycleClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(MoveToNextStepUpdateTask.class);
    private final String policy;
    private final Step.StepKey nextStepKey;
    private final LongSupplier nowSupplier;
    private final PolicyStepsRegistry stepRegistry;
    private final Consumer<ClusterState> stateChangeConsumer;

    public MoveToNextStepUpdateTask(Index index, String policy, Step.StepKey currentStepKey, Step.StepKey nextStepKey, LongSupplier nowSupplier, PolicyStepsRegistry stepRegistry, Consumer<ClusterState> stateChangeConsumer) {
        super(index, currentStepKey);
        this.policy = policy;
        this.nextStepKey = nextStepKey;
        this.nowSupplier = nowSupplier;
        this.stepRegistry = stepRegistry;
        this.stateChangeConsumer = stateChangeConsumer;
    }

    @Override
    public ClusterState doExecute(ClusterState currentState) {
        IndexMetadata idxMeta = currentState.getMetadata().index(this.index);
        if (idxMeta == null) {
            return currentState;
        }
        LifecycleExecutionState lifecycleState = idxMeta.getLifecycleExecutionState();
        if (this.policy.equals(idxMeta.getLifecyclePolicyName()) && this.currentStepKey.equals((Object)Step.getCurrentStepKey((LifecycleExecutionState)lifecycleState))) {
            logger.trace("moving [{}] to next step ({})", (Object)this.index.getName(), (Object)this.nextStepKey);
            return IndexLifecycleTransition.moveClusterStateToStep(this.index, currentState, this.nextStepKey, this.nowSupplier, this.stepRegistry, false);
        }
        return currentState;
    }

    @Override
    public void onClusterStateProcessed(ClusterState newState) {
        this.stateChangeConsumer.accept(newState);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MoveToNextStepUpdateTask that = (MoveToNextStepUpdateTask)o;
        return this.index.equals((Object)that.index) && this.policy.equals(that.policy) && this.currentStepKey.equals((Object)that.currentStepKey) && this.nextStepKey.equals((Object)that.nextStepKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.policy, this.currentStepKey, this.nextStepKey);
    }

    @Override
    public void handleFailure(Exception e) {
        logger.warn(() -> Strings.format((String)"policy [%s] for index [%s] failed trying to move from step [%s] to step [%s].", (Object[])new Object[]{this.policy, this.index, this.currentStepKey, this.nextStepKey}), (Throwable)e);
    }
}

