/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logstash;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.logstash.LogstashFeatureSetUsage;
import org.elasticsearch.xpack.logstash.Logstash;

public class LogstashUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final XPackLicenseState licenseState;

    @Inject
    public LogstashUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, XPackLicenseState licenseState) {
        super(XPackUsageFeatureAction.LOGSTASH.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.licenseState = licenseState;
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        boolean available = Logstash.LOGSTASH_FEATURE.checkWithoutTracking(this.licenseState);
        LogstashFeatureSetUsage usage = new LogstashFeatureSetUsage(available);
        listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureUsage)usage));
    }
}

