/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.langdetect.tika;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tika.langdetect.tika.LanguageIdentifier;
import org.apache.tika.language.detect.LanguageConfidence;
import org.apache.tika.language.detect.LanguageDetector;
import org.apache.tika.language.detect.LanguageResult;

public class TikaLanguageDetector
extends LanguageDetector {
    StringBuilder sb = new StringBuilder();

    public LanguageDetector loadModels() throws IOException {
        return this;
    }

    public LanguageDetector loadModels(Set<String> languages) throws IOException {
        return this;
    }

    public boolean hasModel(String language) {
        return LanguageIdentifier.getSupportedLanguages().contains(language);
    }

    public LanguageDetector setPriors(Map<String, Float> languageProbabilities) throws IOException {
        return null;
    }

    public void reset() {
        this.sb.setLength(0);
    }

    public void addText(char[] cbuf, int off, int len) {
        this.sb.append(cbuf, off, len);
    }

    public List<LanguageResult> detectAll() {
        LanguageIdentifier langIder = new LanguageIdentifier(this.sb.toString());
        String lang = langIder.getLanguage();
        if (langIder.isReasonablyCertain()) {
            return Collections.singletonList(new LanguageResult(lang, LanguageConfidence.MEDIUM, langIder.getRawScore()));
        }
        return Collections.EMPTY_LIST;
    }
}

