/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.shutdown.SingleNodeShutdownStatus;

public class GetShutdownStatusAction
extends ActionType<Response> {
    public static final GetShutdownStatusAction INSTANCE = new GetShutdownStatusAction();
    public static final String NAME = "cluster:admin/shutdown/get";

    public GetShutdownStatusAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContentObject {
        final List<SingleNodeShutdownStatus> shutdownStatuses;

        public Response(List<SingleNodeShutdownStatus> shutdownStatuses) {
            this.shutdownStatuses = Objects.requireNonNull(shutdownStatuses, "shutdown statuses must not be null");
        }

        public Response(StreamInput in) throws IOException {
            this.shutdownStatuses = in.readCollectionAsList(SingleNodeShutdownStatus::new);
        }

        public List<SingleNodeShutdownStatus> getShutdownStatuses() {
            return this.shutdownStatuses;
        }

        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.startArray((String)"nodes"), Iterators.flatMap(this.shutdownStatuses.iterator(), status -> status.toXContentChunked(params)), ChunkedToXContentHelper.endArray(), ChunkedToXContentHelper.endObject()});
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.shutdownStatuses);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.shutdownStatuses.equals(response.shutdownStatuses);
        }

        public int hashCode() {
            return Objects.hash(this.shutdownStatuses);
        }

        public String toString() {
            return Strings.toString((ChunkedToXContent)this);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final String[] nodeIds;

        public Request(TimeValue masterNodeTimeout, String ... nodeIds) {
            super(masterNodeTimeout);
            this.nodeIds = nodeIds;
        }

        public static Request readFrom(StreamInput in) throws IOException {
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0)) {
                return new Request(in);
            }
            return new Request(TimeValue.THIRTY_SECONDS, in);
        }

        private Request(StreamInput in) throws IOException {
            super(in);
            assert (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0));
            this.nodeIds = in.readStringArray();
        }

        private Request(TimeValue masterNodeTimeout, StreamInput in) throws IOException {
            super(masterNodeTimeout);
            assert (in.getTransportVersion().before((VersionId)TransportVersions.V_8_15_0));
            this.nodeIds = in.readStringArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0)) {
                super.writeTo(out);
            }
            out.writeStringArray(this.nodeIds);
        }

        public String[] getNodeIds() {
            return this.nodeIds;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Arrays.equals(this.nodeIds, request.nodeIds);
        }

        public int hashCode() {
            return Arrays.hashCode(this.nodeIds);
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }
    }
}

