/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.http;

import java.io.IOException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.common.http.HttpClient;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.input.InputFactory;
import org.elasticsearch.xpack.watcher.input.http.ExecutableHttpInput;
import org.elasticsearch.xpack.watcher.input.http.HttpInput;

public final class HttpInputFactory
extends InputFactory<HttpInput, HttpInput.Result, ExecutableHttpInput> {
    private final HttpClient httpClient;
    private final TextTemplateEngine templateEngine;

    public HttpInputFactory(Settings settings, HttpClient httpClient, TextTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
        this.httpClient = httpClient;
    }

    @Override
    public String type() {
        return "http";
    }

    @Override
    public HttpInput parseInput(String watchId, XContentParser parser) throws IOException {
        return HttpInput.parse(watchId, parser);
    }

    @Override
    public ExecutableHttpInput createExecutable(HttpInput input) {
        return new ExecutableHttpInput(input, this.httpClient, this.templateEngine);
    }
}

