/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.support.xcontent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.xcontent.ToXContent;

public class WatcherParams
extends ToXContent.DelegatingMapParams {
    public static final WatcherParams HIDE_SECRETS = WatcherParams.builder().hideSecrets(true).build();
    private static final String HIDE_SECRETS_KEY = "hide_secrets";
    private static final String HIDE_HEADERS = "hide_headers";
    private static final String DEBUG_KEY = "debug";

    public static boolean hideSecrets(ToXContent.Params params) {
        return WatcherParams.wrap(params).hideSecrets();
    }

    public static boolean debug(ToXContent.Params params) {
        return WatcherParams.wrap(params).debug();
    }

    public static boolean hideHeaders(ToXContent.Params params) {
        return WatcherParams.wrap(params).hideHeaders();
    }

    private WatcherParams(Map<String, String> params, ToXContent.Params delegate) {
        super(params, delegate);
    }

    private boolean hideSecrets() {
        return this.paramAsBoolean(HIDE_SECRETS_KEY, true);
    }

    private boolean debug() {
        return this.paramAsBoolean(DEBUG_KEY, false);
    }

    private boolean hideHeaders() {
        return this.paramAsBoolean(HIDE_HEADERS, true);
    }

    public static WatcherParams wrap(ToXContent.Params params) {
        return params instanceof WatcherParams ? (WatcherParams)params : new WatcherParams(Collections.emptyMap(), params);
    }

    public static Builder builder() {
        return WatcherParams.builder(ToXContent.EMPTY_PARAMS);
    }

    public static Builder builder(ToXContent.Params delegate) {
        return new Builder(delegate);
    }

    public static class Builder {
        private final ToXContent.Params delegate;
        private final Map<String, String> params = new HashMap<String, String>();

        private Builder(ToXContent.Params delegate) {
            this.delegate = delegate;
        }

        public Builder hideSecrets(boolean hideSecrets) {
            this.params.put(WatcherParams.HIDE_SECRETS_KEY, String.valueOf(hideSecrets));
            return this;
        }

        public Builder hideHeaders(boolean hideHeaders) {
            this.params.put(WatcherParams.HIDE_HEADERS, String.valueOf(hideHeaders));
            return this;
        }

        public Builder debug(boolean debug) {
            this.params.put(WatcherParams.DEBUG_KEY, String.valueOf(debug));
            return this;
        }

        public Builder includeStatus(boolean includeStatus) {
            this.params.put("include_status", String.valueOf(includeStatus));
            return this;
        }

        public Builder put(String key, Object value) {
            this.params.put(key, String.valueOf(value));
            return this;
        }

        public WatcherParams build() {
            return new WatcherParams(Map.copyOf(this.params), this.delegate);
        }
    }
}

