/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.privilege;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.ActionTypes;
import org.elasticsearch.xpack.core.security.action.privilege.ApplicationPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.profile.UpdateProfileDataRequest;
import org.elasticsearch.xpack.core.security.action.role.BulkDeleteRolesRequest;
import org.elasticsearch.xpack.core.security.action.role.BulkPutRolesRequest;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleRequest;
import org.elasticsearch.xpack.core.security.action.role.PutRoleRequest;
import org.elasticsearch.xpack.core.security.authz.RestrictedIndices;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.support.StringMatcher;
import org.elasticsearch.xpack.core.security.xcontent.XContentUtils;

public final class ConfigurableClusterPrivileges {
    public static final ConfigurableClusterPrivilege[] EMPTY_ARRAY = new ConfigurableClusterPrivilege[0];
    private static final Logger logger = LogManager.getLogger(ConfigurableClusterPrivileges.class);
    public static final Writeable.Reader<ConfigurableClusterPrivilege> READER = in1 -> (ConfigurableClusterPrivilege)in1.readNamedWriteable(ConfigurableClusterPrivilege.class);
    public static final Writeable.Writer<ConfigurableClusterPrivilege> WRITER = (out1, value) -> out1.writeNamedWriteable((NamedWriteable)value);

    private ConfigurableClusterPrivileges() {
    }

    public static ConfigurableClusterPrivilege[] readArray(StreamInput in) throws IOException {
        return (ConfigurableClusterPrivilege[])in.readArray(READER, ConfigurableClusterPrivilege[]::new);
    }

    public static void writeArray(StreamOutput out, ConfigurableClusterPrivilege[] privileges) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ADD_MANAGE_ROLES_PRIVILEGE)) {
            out.writeArray(WRITER, (Object[])privileges);
        } else {
            out.writeArray(WRITER, (Object[])((ConfigurableClusterPrivilege[])Arrays.stream(privileges).filter(privilege -> !(privilege instanceof ManageRolesPrivilege)).toArray(ConfigurableClusterPrivilege[]::new)));
        }
    }

    public static XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, Collection<ConfigurableClusterPrivilege> privileges) throws IOException {
        builder.startObject();
        for (ConfigurableClusterPrivilege.Category category : ConfigurableClusterPrivilege.Category.values()) {
            builder.startObject(category.field.getPreferredName());
            for (ConfigurableClusterPrivilege privilege : privileges) {
                if (category != privilege.getCategory()) continue;
                privilege.toXContent(builder, params);
            }
            builder.endObject();
        }
        return builder.endObject();
    }

    public static List<ConfigurableClusterPrivilege> parse(XContentParser parser) throws IOException {
        ArrayList<ConfigurableClusterPrivilege> privileges = new ArrayList<ConfigurableClusterPrivilege>();
        ConfigurableClusterPrivileges.expectedToken(parser.currentToken(), parser, XContentParser.Token.START_OBJECT);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            ConfigurableClusterPrivileges.expectedToken(parser.currentToken(), parser, XContentParser.Token.FIELD_NAME);
            ConfigurableClusterPrivileges.expectFieldName(parser, ConfigurableClusterPrivilege.Category.APPLICATION.field, ConfigurableClusterPrivilege.Category.PROFILE.field, ConfigurableClusterPrivilege.Category.ROLE.field);
            if (ConfigurableClusterPrivilege.Category.APPLICATION.field.match(parser.currentName(), parser.getDeprecationHandler())) {
                ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_OBJECT);
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    ConfigurableClusterPrivileges.expectedToken(parser.currentToken(), parser, XContentParser.Token.FIELD_NAME);
                    ConfigurableClusterPrivileges.expectFieldName(parser, ManageApplicationPrivileges.Fields.MANAGE);
                    privileges.add(ManageApplicationPrivileges.parse(parser));
                }
                continue;
            }
            if (ConfigurableClusterPrivilege.Category.PROFILE.field.match(parser.currentName(), parser.getDeprecationHandler())) {
                ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_OBJECT);
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    ConfigurableClusterPrivileges.expectedToken(parser.currentToken(), parser, XContentParser.Token.FIELD_NAME);
                    ConfigurableClusterPrivileges.expectFieldName(parser, WriteProfileDataPrivileges.Fields.WRITE);
                    privileges.add(WriteProfileDataPrivileges.parse(parser));
                }
                continue;
            }
            if (!ConfigurableClusterPrivilege.Category.ROLE.field.match(parser.currentName(), parser.getDeprecationHandler())) continue;
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_OBJECT);
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                ConfigurableClusterPrivileges.expectedToken(parser.currentToken(), parser, XContentParser.Token.FIELD_NAME);
                ConfigurableClusterPrivileges.expectFieldName(parser, ManageRolesPrivilege.Fields.MANAGE);
                privileges.add(ManageRolesPrivilege.parse(parser));
            }
        }
        return privileges;
    }

    private static void expectedToken(XContentParser.Token read, XContentParser parser, XContentParser.Token expected) {
        if (read != expected) {
            throw new XContentParseException(parser.getTokenLocation(), "failed to parse privilege. expected [" + String.valueOf(expected) + "] but found [" + String.valueOf(read) + "] instead");
        }
    }

    private static void expectFieldName(XContentParser parser, ParseField ... fields) throws IOException {
        String fieldName = parser.currentName();
        if (!Arrays.stream(fields).anyMatch(pf -> pf.match(fieldName, parser.getDeprecationHandler()))) {
            throw new XContentParseException(parser.getTokenLocation(), "failed to parse privilege. expected " + (fields.length == 1 ? "field name" : "one of") + " [" + Strings.arrayToCommaDelimitedString((Object[])fields) + "] but found [" + fieldName + "] instead");
        }
    }

    public static class ManageApplicationPrivileges
    implements ConfigurableClusterPrivilege {
        public static final String WRITEABLE_NAME = "manage-application-privileges";
        private final Set<String> applicationNames;
        private final Predicate<String> applicationPredicate;
        private final Predicate<TransportRequest> requestPredicate;

        public ManageApplicationPrivileges(Set<String> applicationNames) {
            this.applicationNames = Collections.unmodifiableSet(applicationNames);
            this.applicationPredicate = StringMatcher.of(applicationNames);
            this.requestPredicate = request -> {
                if (request instanceof ApplicationPrivilegesRequest) {
                    ApplicationPrivilegesRequest privRequest = (ApplicationPrivilegesRequest)request;
                    Collection<String> requestApplicationNames = privRequest.getApplicationNames();
                    return requestApplicationNames.isEmpty() ? this.applicationNames.contains("*") : requestApplicationNames.stream().allMatch(this.applicationPredicate);
                }
                return false;
            };
        }

        @Override
        public ConfigurableClusterPrivilege.Category getCategory() {
            return ConfigurableClusterPrivilege.Category.APPLICATION;
        }

        public Collection<String> getApplicationNames() {
            return this.applicationNames;
        }

        public String getWriteableName() {
            return WRITEABLE_NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.applicationNames);
        }

        public static ManageApplicationPrivileges createFrom(StreamInput in) throws IOException {
            Set applications = in.readCollectionAsSet(StreamInput::readString);
            return new ManageApplicationPrivileges(applications);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(Fields.MANAGE.getPreferredName(), Map.of(Fields.APPLICATIONS.getPreferredName(), this.applicationNames));
        }

        public static ManageApplicationPrivileges parse(XContentParser parser) throws IOException {
            ConfigurableClusterPrivileges.expectedToken(parser.currentToken(), parser, XContentParser.Token.FIELD_NAME);
            ConfigurableClusterPrivileges.expectFieldName(parser, Fields.MANAGE);
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_OBJECT);
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.FIELD_NAME);
            ConfigurableClusterPrivileges.expectFieldName(parser, Fields.APPLICATIONS);
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_ARRAY);
            String[] applications = XContentUtils.readStringArray(parser, false);
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.END_OBJECT);
            return new ManageApplicationPrivileges(new LinkedHashSet<String>(Arrays.asList(applications)));
        }

        public String toString() {
            return "{" + String.valueOf((Object)this.getCategory()) + ":" + Fields.MANAGE.getPreferredName() + ":" + Fields.APPLICATIONS.getPreferredName() + "=" + Strings.collectionToDelimitedString(this.applicationNames, (String)",") + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManageApplicationPrivileges that = (ManageApplicationPrivileges)o;
            return this.applicationNames.equals(that.applicationNames);
        }

        public int hashCode() {
            return this.applicationNames.hashCode();
        }

        @Override
        public ClusterPermission.Builder buildPermission(ClusterPermission.Builder builder) {
            return builder.add((ClusterPrivilege)this, Set.of("cluster:admin/xpack/security/privilege/*"), this.requestPredicate);
        }

        private static interface Fields {
            public static final ParseField MANAGE = new ParseField("manage", new String[0]);
            public static final ParseField APPLICATIONS = new ParseField("applications", new String[0]);
        }
    }

    public static class WriteProfileDataPrivileges
    implements ConfigurableClusterPrivilege {
        public static final String WRITEABLE_NAME = "write-profile-data-privileges";
        private final Set<String> applicationNames;
        private final Predicate<String> applicationPredicate;
        private final Predicate<TransportRequest> requestPredicate;

        public WriteProfileDataPrivileges(Set<String> applicationNames) {
            this.applicationNames = Collections.unmodifiableSet(applicationNames);
            this.applicationPredicate = StringMatcher.of(applicationNames);
            this.requestPredicate = request -> {
                if (request instanceof UpdateProfileDataRequest) {
                    UpdateProfileDataRequest updateProfileRequest = (UpdateProfileDataRequest)((Object)request);
                    assert (null == updateProfileRequest.validate());
                    Set<String> requestApplicationNames = updateProfileRequest.getApplicationNames();
                    return requestApplicationNames.stream().allMatch(this.applicationPredicate);
                }
                return false;
            };
        }

        @Override
        public ConfigurableClusterPrivilege.Category getCategory() {
            return ConfigurableClusterPrivilege.Category.PROFILE;
        }

        public Collection<String> getApplicationNames() {
            return this.applicationNames;
        }

        public String getWriteableName() {
            return WRITEABLE_NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.applicationNames);
        }

        public static WriteProfileDataPrivileges createFrom(StreamInput in) throws IOException {
            Set applications = in.readCollectionAsSet(StreamInput::readString);
            return new WriteProfileDataPrivileges(applications);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(Fields.WRITE.getPreferredName(), Map.of(Fields.APPLICATIONS.getPreferredName(), this.applicationNames));
        }

        public static WriteProfileDataPrivileges parse(XContentParser parser) throws IOException {
            ConfigurableClusterPrivileges.expectedToken(parser.currentToken(), parser, XContentParser.Token.FIELD_NAME);
            ConfigurableClusterPrivileges.expectFieldName(parser, Fields.WRITE);
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_OBJECT);
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.FIELD_NAME);
            ConfigurableClusterPrivileges.expectFieldName(parser, Fields.APPLICATIONS);
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_ARRAY);
            String[] applications = XContentUtils.readStringArray(parser, false);
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.END_OBJECT);
            return new WriteProfileDataPrivileges(new LinkedHashSet<String>(Arrays.asList(applications)));
        }

        public String toString() {
            return "{" + String.valueOf((Object)this.getCategory()) + ":" + Fields.WRITE.getPreferredName() + ":" + Fields.APPLICATIONS.getPreferredName() + "=" + Strings.collectionToDelimitedString(this.applicationNames, (String)",") + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WriteProfileDataPrivileges that = (WriteProfileDataPrivileges)o;
            return this.applicationNames.equals(that.applicationNames);
        }

        public int hashCode() {
            return this.applicationNames.hashCode();
        }

        @Override
        public ClusterPermission.Builder buildPermission(ClusterPermission.Builder builder) {
            return builder.add((ClusterPrivilege)this, Set.of("cluster:admin/xpack/security/profile/put/data"), this.requestPredicate);
        }

        private static interface Fields {
            public static final ParseField WRITE = new ParseField("write", new String[0]);
            public static final ParseField APPLICATIONS = new ParseField("applications", new String[0]);
        }
    }

    public static class ManageRolesPrivilege
    implements ConfigurableClusterPrivilege {
        public static final String WRITEABLE_NAME = "manage-roles-privilege";
        private final List<ManageRolesIndexPermissionGroup> indexPermissionGroups;
        private final Function<RestrictedIndices, Predicate<TransportRequest>> requestPredicateSupplier;
        private static final Set<String> EXPECTED_INDEX_GROUP_FIELDS = Set.of(Fields.NAMES.getPreferredName(), Fields.PRIVILEGES.getPreferredName());

        public ManageRolesPrivilege(List<ManageRolesIndexPermissionGroup> manageRolesIndexPermissionGroups) {
            this.indexPermissionGroups = manageRolesIndexPermissionGroups;
            this.requestPredicateSupplier = restrictedIndices -> {
                IndicesPermission.Builder indicesPermissionBuilder = new IndicesPermission.Builder((RestrictedIndices)restrictedIndices);
                for (ManageRolesIndexPermissionGroup indexPatternPrivilege : manageRolesIndexPermissionGroups) {
                    indicesPermissionBuilder.addGroup(IndexPrivilege.get(Set.of(indexPatternPrivilege.privileges())), FieldPermissions.DEFAULT, null, false, indexPatternPrivilege.indexPatterns());
                }
                IndicesPermission indicesPermission = indicesPermissionBuilder.build();
                return request -> {
                    if (request instanceof PutRoleRequest) {
                        PutRoleRequest putRoleRequest = (PutRoleRequest)((Object)((Object)request));
                        return !ManageRolesPrivilege.hasNonIndexPrivileges(putRoleRequest.roleDescriptor()) && Arrays.stream(putRoleRequest.indices()).noneMatch(indexPrivilege -> !ManageRolesPrivilege.requestIndexPatternsAllowed(indicesPermission, indexPrivilege.getIndices(), indexPrivilege.getPrivileges()));
                    }
                    if (request instanceof BulkPutRolesRequest) {
                        BulkPutRolesRequest bulkPutRoleRequest = (BulkPutRolesRequest)((Object)((Object)request));
                        return bulkPutRoleRequest.getRoles().stream().noneMatch(ManageRolesPrivilege::hasNonIndexPrivileges) && bulkPutRoleRequest.getRoles().stream().allMatch(roleDescriptor -> Arrays.stream(roleDescriptor.getIndicesPrivileges()).noneMatch(indexPrivilege -> !ManageRolesPrivilege.requestIndexPatternsAllowed(indicesPermission, indexPrivilege.getIndices(), indexPrivilege.getPrivileges())));
                    }
                    if (request instanceof DeleteRoleRequest) {
                        DeleteRoleRequest deleteRoleRequest = (DeleteRoleRequest)((Object)((Object)request));
                        return ManageRolesPrivilege.requestIndexPatternsAllowed(indicesPermission, new String[]{deleteRoleRequest.name()}, (String[])IndexPrivilege.DELETE_INDEX.name().toArray(String[]::new));
                    }
                    if (request instanceof BulkDeleteRolesRequest) {
                        BulkDeleteRolesRequest bulkDeleteRoleRequest = (BulkDeleteRolesRequest)((Object)((Object)request));
                        return ManageRolesPrivilege.requestIndexPatternsAllowed(indicesPermission, (String[])bulkDeleteRoleRequest.getRoleNames().toArray(String[]::new), (String[])IndexPrivilege.DELETE_INDEX.name().toArray(String[]::new));
                    }
                    throw new IllegalArgumentException("Unsupported request type [" + String.valueOf(request.getClass()) + "]");
                };
            };
        }

        @Override
        public ConfigurableClusterPrivilege.Category getCategory() {
            return ConfigurableClusterPrivilege.Category.ROLE;
        }

        public String getWriteableName() {
            return WRITEABLE_NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.indexPermissionGroups);
        }

        public static ManageRolesPrivilege createFrom(StreamInput in) throws IOException {
            List indexPatternPrivileges = in.readCollectionAsList(ManageRolesIndexPermissionGroup::createFrom);
            return new ManageRolesPrivilege(indexPatternPrivileges);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(Fields.MANAGE.getPreferredName(), Map.of(Fields.INDICES.getPreferredName(), this.indexPermissionGroups.stream().map(indexPatternPrivilege -> {
                TreeMap<String, String[]> sortedMap = new TreeMap<String, String[]>();
                sortedMap.put(Fields.NAMES.getPreferredName(), indexPatternPrivilege.indexPatterns());
                sortedMap.put(Fields.PRIVILEGES.getPreferredName(), indexPatternPrivilege.privileges());
                return sortedMap;
            }).toList()));
        }

        private static void expectedIndexGroupFields(String fieldName, XContentParser parser) {
            if (!EXPECTED_INDEX_GROUP_FIELDS.contains(fieldName)) {
                throw new XContentParseException(parser.getTokenLocation(), "failed to parse privilege. expected one of " + Arrays.toString(EXPECTED_INDEX_GROUP_FIELDS.toArray(String[]::new)) + " but found [" + fieldName + "] instead");
            }
        }

        public static ManageRolesPrivilege parse(XContentParser parser) throws IOException {
            XContentParser.Token token;
            ConfigurableClusterPrivileges.expectedToken(parser.currentToken(), parser, XContentParser.Token.FIELD_NAME);
            ConfigurableClusterPrivileges.expectFieldName(parser, Fields.MANAGE);
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_OBJECT);
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.FIELD_NAME);
            ConfigurableClusterPrivileges.expectFieldName(parser, Fields.INDICES);
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_ARRAY);
            ArrayList<ManageRolesIndexPermissionGroup> indexPrivileges = new ArrayList<ManageRolesIndexPermissionGroup>();
            HashMap<String, String[]> parsedArraysByFieldName = new HashMap<String, String[]>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                ConfigurableClusterPrivileges.expectedToken(token, parser, XContentParser.Token.START_OBJECT);
                ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.FIELD_NAME);
                String currentFieldName = parser.currentName();
                ManageRolesPrivilege.expectedIndexGroupFields(currentFieldName, parser);
                ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_ARRAY);
                parsedArraysByFieldName.put(currentFieldName, XContentUtils.readStringArray(parser, false));
                ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.FIELD_NAME);
                currentFieldName = parser.currentName();
                ManageRolesPrivilege.expectedIndexGroupFields(currentFieldName, parser);
                ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_ARRAY);
                parsedArraysByFieldName.put(currentFieldName, XContentUtils.readStringArray(parser, false));
                ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.END_OBJECT);
                indexPrivileges.add(new ManageRolesIndexPermissionGroup((String[])parsedArraysByFieldName.get(Fields.NAMES.getPreferredName()), (String[])parsedArraysByFieldName.get(Fields.PRIVILEGES.getPreferredName())));
            }
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.END_OBJECT);
            for (ManageRolesIndexPermissionGroup indexPrivilege : indexPrivileges) {
                if (indexPrivilege.indexPatterns == null || indexPrivilege.indexPatterns.length == 0) {
                    throw new IllegalArgumentException("Indices privileges must refer to at least one index name or index name pattern");
                }
                if (indexPrivilege.privileges != null && indexPrivilege.privileges.length != 0) continue;
                throw new IllegalArgumentException("Indices privileges must define at least one privilege");
            }
            return new ManageRolesPrivilege(indexPrivileges);
        }

        public String toString() {
            return "{" + String.valueOf((Object)this.getCategory()) + ":" + Fields.MANAGE.getPreferredName() + ":" + Fields.INDICES.getPreferredName() + "=[" + Strings.collectionToDelimitedString(this.indexPermissionGroups, (String)",") + "]}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManageRolesPrivilege that = (ManageRolesPrivilege)o;
            if (this.indexPermissionGroups.size() != that.indexPermissionGroups.size()) {
                return false;
            }
            for (int i = 0; i < this.indexPermissionGroups.size(); ++i) {
                if (Objects.equals(this.indexPermissionGroups.get(i), that.indexPermissionGroups.get(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.indexPermissionGroups.hashCode());
        }

        @Override
        public ClusterPermission.Builder buildPermission(ClusterPermission.Builder builder) {
            return builder.addWithPredicateSupplier(this, Set.of("cluster:admin/xpack/security/role/put", ActionTypes.BULK_PUT_ROLES.name(), ActionTypes.BULK_DELETE_ROLES.name(), "cluster:admin/xpack/security/role/delete"), this.requestPredicateSupplier);
        }

        private static boolean requestIndexPatternsAllowed(IndicesPermission indicesPermission, String[] requestIndexPatterns, String[] privileges) {
            return indicesPermission.checkResourcePrivileges(Set.of(requestIndexPatterns), false, Set.of(privileges), true, null);
        }

        private static boolean hasNonIndexPrivileges(RoleDescriptor roleDescriptor) {
            return roleDescriptor.hasApplicationPrivileges() || roleDescriptor.hasClusterPrivileges() || roleDescriptor.hasConfigurableClusterPrivileges() || roleDescriptor.hasRemoteIndicesPrivileges() || roleDescriptor.hasRemoteClusterPermissions() || roleDescriptor.hasRunAs() || roleDescriptor.hasWorkflowsRestriction();
        }

        private static interface Fields {
            public static final ParseField MANAGE = new ParseField("manage", new String[0]);
            public static final ParseField INDICES = new ParseField("indices", new String[0]);
            public static final ParseField PRIVILEGES = new ParseField("privileges", new String[0]);
            public static final ParseField NAMES = new ParseField("names", new String[0]);
        }

        public record ManageRolesIndexPermissionGroup(String[] indexPatterns, String[] privileges) implements Writeable
        {
            public static ManageRolesIndexPermissionGroup createFrom(StreamInput in) throws IOException {
                return new ManageRolesIndexPermissionGroup(in.readStringArray(), in.readStringArray());
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeStringArray(this.indexPatterns);
                out.writeStringArray(this.privileges);
            }

            @Override
            public String toString() {
                return "{" + String.valueOf(Fields.NAMES) + ":" + Arrays.toString(this.indexPatterns()) + ":" + String.valueOf(Fields.PRIVILEGES) + ":" + Arrays.toString(this.privileges()) + "}";
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ManageRolesIndexPermissionGroup that = (ManageRolesIndexPermissionGroup)o;
                return Arrays.equals(this.indexPatterns, that.indexPatterns) && Arrays.equals(this.privileges, that.privileges);
            }

            @Override
            public int hashCode() {
                return Objects.hash(Arrays.hashCode(this.indexPatterns), Arrays.hashCode(this.privileges));
            }
        }
    }
}

