/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.VersionId;

public class TransportVersionUtils {
    private TransportVersionUtils() {
    }

    public static TransportVersion getMinTransportVersion(ClusterState state) {
        return state.getMinTransportVersion();
    }

    public static TransportVersion getCurrentTransportVersion() {
        return TransportVersion.current();
    }

    public static boolean isMinTransportVersionSameAsCurrent(ClusterState state) {
        TransportVersion currentTransformVersion;
        TransportVersion minTransportVersion = TransportVersionUtils.getMinTransportVersion(state);
        return minTransportVersion.compareTo((VersionId)(currentTransformVersion = TransportVersion.current())) == 0;
    }

    public static boolean isMinTransportVersionOnOrAfter(ClusterState state, TransportVersion version) {
        return TransportVersionUtils.getMinTransportVersion(state).onOrAfter((VersionId)version);
    }
}

