/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.LenientlyParsedTrainedModelLocation;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.StrictlyParsedTrainedModelLocation;

public class IndexLocation
implements StrictlyParsedTrainedModelLocation,
LenientlyParsedTrainedModelLocation {
    public static final ParseField INDEX = new ParseField("index", new String[0]);
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ConstructingObjectParser<IndexLocation, Void> LENIENT_PARSER = IndexLocation.createParser(true);
    private static final ConstructingObjectParser<IndexLocation, Void> STRICT_PARSER = IndexLocation.createParser(false);
    private final String indexName;

    private static ConstructingObjectParser<IndexLocation, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME.getPreferredName(), lenient, a -> new IndexLocation((String)a[0]));
        parser.declareString(ConstructingObjectParser.constructorArg(), NAME);
        return parser;
    }

    public static IndexLocation fromXContentStrict(XContentParser parser) throws IOException {
        return (IndexLocation)STRICT_PARSER.parse(parser, null);
    }

    public static IndexLocation fromXContentLenient(XContentParser parser) throws IOException {
        return (IndexLocation)LENIENT_PARSER.parse(parser, null);
    }

    public IndexLocation(String indexName) {
        this.indexName = Objects.requireNonNull(indexName);
    }

    public IndexLocation(StreamInput in) throws IOException {
        this.indexName = in.readString();
    }

    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public String getResourceName() {
        return this.getIndexName();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME.getPreferredName(), this.indexName);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
    }

    public String getWriteableName() {
        return INDEX.getPreferredName();
    }

    @Override
    public String getName() {
        return INDEX.getPreferredName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexLocation that = (IndexLocation)o;
        return Objects.equals(this.indexName, that.indexName);
    }

    public int hashCode() {
        return Objects.hash(this.indexName);
    }
}

