/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class CleanupTargetIndexStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "cleanup-target-index";
    private static final Logger logger = LogManager.getLogger(CleanupTargetIndexStep.class);
    private final Function<IndexMetadata, String> sourceIndexNameSupplier;
    private final Function<IndexMetadata, String> targetIndexNameSupplier;

    public CleanupTargetIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, Function<IndexMetadata, String> sourceIndexNameSupplier, Function<IndexMetadata, String> targetIndexNameSupplier) {
        super(key, nextStepKey, client);
        this.sourceIndexNameSupplier = sourceIndexNameSupplier;
        this.targetIndexNameSupplier = targetIndexNameSupplier;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    Function<IndexMetadata, String> getSourceIndexNameSupplier() {
        return this.sourceIndexNameSupplier;
    }

    Function<IndexMetadata, String> getTargetIndexNameSupplier() {
        return this.targetIndexNameSupplier;
    }

    @Override
    void performDuringNoSnapshot(IndexMetadata indexMetadata, ClusterState currentClusterState, final ActionListener<Void> listener) {
        String sourceIndexName = this.sourceIndexNameSupplier.apply(indexMetadata);
        if (!Strings.isNullOrEmpty((String)sourceIndexName) && currentClusterState.metadata().index(sourceIndexName) == null) {
            String policyName = indexMetadata.getLifecyclePolicyName();
            logger.warn("managed index [{}] has been created as part of policy [{}] and the source index [{}] does not exist anymore. will skip the [{}] step", (Object)indexMetadata.getIndex().getName(), (Object)policyName, (Object)sourceIndexName, (Object)NAME);
            listener.onResponse(null);
            return;
        }
        String targetIndexName = this.targetIndexNameSupplier.apply(indexMetadata);
        if (!Strings.hasText((String)targetIndexName)) {
            listener.onResponse(null);
            return;
        }
        this.getClient().admin().indices().delete((DeleteIndexRequest)new DeleteIndexRequest(targetIndexName).masterNodeTimeout(TimeValue.MAX_VALUE), (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                listener.onResponse(null);
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    listener.onResponse(null);
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CleanupTargetIndexStep that = (CleanupTargetIndexStep)o;
        return super.equals(o) && Objects.equals(this.targetIndexNameSupplier, that.targetIndexNameSupplier) && Objects.equals(this.sourceIndexNameSupplier, that.sourceIndexNameSupplier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetIndexNameSupplier, this.sourceIndexNameSupplier);
    }
}

