/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.stats;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.xpack.esql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public class PlanningMetrics {
    private Map<String, Integer> commands = new HashMap<String, Integer>();
    private Map<String, Integer> functions = new HashMap<String, Integer>();

    public void gatherPreAnalysisMetrics(LogicalPlan plan) {
        plan.forEachDown(p -> this.add(this.commands, p.commandName()));
        plan.forEachExpressionDown(UnresolvedFunction.class, p -> this.add(this.functions, p.name().toUpperCase(Locale.ROOT)));
    }

    private void add(Map<String, Integer> map, String key) {
        Integer cmd = map.get(key);
        map.put(key, cmd == null ? 1 : cmd + 1);
    }

    public Map<String, Integer> commands() {
        return this.commands;
    }

    public Map<String, Integer> functions() {
        return this.functions;
    }
}

