/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.esql.action.EsqlResolveFieldsAction;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DateEsField;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.InvalidMappedField;
import org.elasticsearch.xpack.esql.core.type.KeywordEsField;
import org.elasticsearch.xpack.esql.core.type.TextEsField;
import org.elasticsearch.xpack.esql.core.type.UnsupportedEsField;
import org.elasticsearch.xpack.esql.index.EsIndex;
import org.elasticsearch.xpack.esql.index.IndexResolution;
import org.elasticsearch.xpack.esql.session.EsqlSessionCCSUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeRegistry;

public class IndexResolver {
    public static final Set<String> ALL_FIELDS = Set.of("*");
    public static final Set<String> INDEX_METADATA_FIELD = Set.of("_index");
    public static final String UNMAPPED = "unmapped";
    public static final IndicesOptions FIELD_CAPS_INDICES_OPTIONS = IndicesOptions.builder().concreteTargetOptions(IndicesOptions.ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS).wildcardOptions(IndicesOptions.WildcardOptions.builder().matchOpen(true).matchClosed(false).includeHidden(false).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(IndicesOptions.GatekeeperOptions.builder().ignoreThrottled(true).allowClosedIndices(true).allowAliasToMultipleIndices(true)).build();
    private final Client client;

    public IndexResolver(Client client) {
        this.client = client;
    }

    public void resolveAsMergedMapping(String indexWildcard, Set<String> fieldNames, ActionListener<IndexResolution> listener) {
        this.client.execute(EsqlResolveFieldsAction.TYPE, (ActionRequest)IndexResolver.createFieldCapsRequest(indexWildcard, fieldNames), listener.delegateFailureAndWrap((l, response) -> l.onResponse((Object)this.mergedMappings(indexWildcard, (FieldCapabilitiesResponse)response))));
    }

    public IndexResolution mergedMappings(String indexPattern, FieldCapabilitiesResponse fieldCapsResponse) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"search_coordination"}));
        if (fieldCapsResponse.getIndexResponses().isEmpty()) {
            return IndexResolution.notFound(indexPattern);
        }
        Map<String, List<IndexFieldCapabilities>> fieldsCaps = IndexResolver.collectFieldCaps(fieldCapsResponse);
        Object[] names = fieldsCaps.keySet().toArray(new String[0]);
        Arrays.sort(names);
        HashMap<String, EsField> rootFields = new HashMap<String, EsField>();
        for (Object name : names) {
            int nextDot;
            Map<String, Object> fields = rootFields;
            Object fullName = name;
            boolean isAlias = false;
            UnsupportedEsField firstUnsupportedParent = null;
            while ((nextDot = ((String)name).indexOf(46)) >= 0) {
                String parent = ((String)name).substring(0, nextDot);
                EsField obj = (EsField)fields.get(parent);
                if (obj == null) {
                    obj = new EsField(parent, DataType.OBJECT, new HashMap(), false, true);
                    isAlias = true;
                    fields.put(parent, obj);
                } else if (firstUnsupportedParent == null && obj instanceof UnsupportedEsField) {
                    UnsupportedEsField unsupportedParent;
                    firstUnsupportedParent = unsupportedParent = (UnsupportedEsField)obj;
                }
                fields = obj.getProperties();
                name = ((String)name).substring(nextDot + 1);
            }
            UnsupportedEsField field = firstUnsupportedParent == null ? this.createField(fieldCapsResponse, (String)name, (String)fullName, fieldsCaps.get(fullName), isAlias) : new UnsupportedEsField((String)fullName, firstUnsupportedParent.getOriginalType(), firstUnsupportedParent.getName(), new HashMap());
            fields.put((String)name, (EsField)field);
        }
        Map<String, FieldCapabilitiesFailure> unavailableRemotes = EsqlSessionCCSUtils.determineUnavailableRemoteClusters(fieldCapsResponse.getFailures());
        Map concreteIndices = Maps.newMapWithExpectedSize((int)fieldCapsResponse.getIndexResponses().size());
        for (FieldCapabilitiesIndexResponse ir : fieldCapsResponse.getIndexResponses()) {
            concreteIndices.put(ir.getIndexName(), ir.getIndexMode());
        }
        boolean allEmpty = true;
        for (FieldCapabilitiesIndexResponse ir : fieldCapsResponse.getIndexResponses()) {
            allEmpty &= ir.get().isEmpty();
        }
        if (allEmpty) {
            return IndexResolution.valid(new EsIndex(indexPattern, rootFields, Map.of()), concreteIndices.keySet(), unavailableRemotes);
        }
        return IndexResolution.valid(new EsIndex(indexPattern, rootFields, concreteIndices), concreteIndices.keySet(), unavailableRemotes);
    }

    private static Map<String, List<IndexFieldCapabilities>> collectFieldCaps(FieldCapabilitiesResponse fieldCapsResponse) {
        HashSet<String> seenHashes = new HashSet<String>();
        HashMap<String, List<IndexFieldCapabilities>> fieldsCaps = new HashMap<String, List<IndexFieldCapabilities>>();
        for (FieldCapabilitiesIndexResponse response : fieldCapsResponse.getIndexResponses()) {
            if (!seenHashes.add(response.getIndexMappingHash())) continue;
            for (IndexFieldCapabilities fc : response.get().values()) {
                if (fc.isMetadatafield()) continue;
                List all = fieldsCaps.computeIfAbsent(fc.name(), _key -> new ArrayList());
                all.add(fc);
            }
        }
        return fieldsCaps;
    }

    private EsField createField(FieldCapabilitiesResponse fieldCapsResponse, String name, String fullName, List<IndexFieldCapabilities> fcs, boolean isAlias) {
        IndexFieldCapabilities first = fcs.get(0);
        List<IndexFieldCapabilities> rest = fcs.subList(1, fcs.size());
        DataType type = EsqlDataTypeRegistry.INSTANCE.fromEs(first.type(), first.metricType());
        boolean aggregatable = first.isAggregatable();
        if (!rest.isEmpty()) {
            for (IndexFieldCapabilities fc : rest) {
                if (first.metricType() == fc.metricType()) continue;
                return this.conflictingMetricTypes(name, fullName, fieldCapsResponse);
            }
            for (IndexFieldCapabilities fc : rest) {
                if (type == EsqlDataTypeRegistry.INSTANCE.fromEs(fc.type(), fc.metricType())) continue;
                return this.conflictingTypes(name, fullName, fieldCapsResponse);
            }
            for (IndexFieldCapabilities fc : rest) {
                aggregatable &= fc.isAggregatable();
            }
        }
        if (type == DataType.TEXT) {
            return new TextEsField(name, new HashMap(), false, isAlias);
        }
        if (type == DataType.KEYWORD) {
            int length = Short.MAX_VALUE;
            boolean normalized = false;
            return new KeywordEsField(name, new HashMap(), aggregatable, length, normalized, isAlias);
        }
        if (type == DataType.DATETIME) {
            return DateEsField.dateEsField((String)name, new HashMap(), (boolean)aggregatable);
        }
        if (type == DataType.UNSUPPORTED) {
            return this.unsupported(name, first);
        }
        return new EsField(name, type, new HashMap(), aggregatable, isAlias);
    }

    private UnsupportedEsField unsupported(String name, IndexFieldCapabilities fc) {
        String originalType = fc.metricType() == TimeSeriesParams.MetricType.COUNTER ? "counter" : fc.type();
        return new UnsupportedEsField(name, originalType);
    }

    private EsField conflictingTypes(String name, String fullName, FieldCapabilitiesResponse fieldCapsResponse) {
        TreeMap<String, Set> typesToIndices = new TreeMap<String, Set>();
        for (FieldCapabilitiesIndexResponse ir : fieldCapsResponse.getIndexResponses()) {
            IndexFieldCapabilities fc = (IndexFieldCapabilities)ir.get().get(fullName);
            if (fc == null) continue;
            DataType type = EsqlDataTypeRegistry.INSTANCE.fromEs(fc.type(), fc.metricType());
            if (type == DataType.UNSUPPORTED) {
                return this.unsupported(name, fc);
            }
            typesToIndices.computeIfAbsent(type.typeName(), _key -> new TreeSet()).add(ir.getIndexName());
        }
        return new InvalidMappedField(name, typesToIndices);
    }

    private EsField conflictingMetricTypes(String name, String fullName, FieldCapabilitiesResponse fieldCapsResponse) {
        TreeSet<String> indices = new TreeSet<String>();
        for (FieldCapabilitiesIndexResponse ir : fieldCapsResponse.getIndexResponses()) {
            IndexFieldCapabilities fc = (IndexFieldCapabilities)ir.get().get(fullName);
            if (fc == null) continue;
            indices.add(ir.getIndexName());
        }
        return new InvalidMappedField(name, "mapped as different metric types in indices: " + String.valueOf(indices));
    }

    private static FieldCapabilitiesRequest createFieldCapsRequest(String index, Set<String> fieldNames) {
        FieldCapabilitiesRequest req = new FieldCapabilitiesRequest().indices(Strings.commaDelimitedListToStringArray((String)index));
        req.fields((String[])fieldNames.toArray(String[]::new));
        req.includeUnmapped(true);
        req.indicesOptions(FIELD_CAPS_INDICES_OPTIONS);
        req.filters(new String[]{"-nested"});
        req.setMergeResults(false);
        return req;
    }
}

