/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.analysis.Analyzer;
import org.elasticsearch.xpack.esql.index.IndexResolution;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.session.NoClustersToSearchException;
import org.elasticsearch.xpack.esql.session.Result;

class EsqlSessionCCSUtils {
    private EsqlSessionCCSUtils() {
    }

    static Map<String, FieldCapabilitiesFailure> determineUnavailableRemoteClusters(List<FieldCapabilitiesFailure> failures) {
        HashMap<String, FieldCapabilitiesFailure> unavailableRemotes = new HashMap<String, FieldCapabilitiesFailure>();
        for (FieldCapabilitiesFailure failure : failures) {
            if (!ExceptionsHelper.isRemoteUnavailableException((Exception)failure.getException())) continue;
            for (String indexExpression : failure.getIndices()) {
                if (indexExpression.indexOf(58) <= 0) continue;
                unavailableRemotes.put(RemoteClusterAware.parseClusterAlias((String)indexExpression), failure);
            }
        }
        return unavailableRemotes;
    }

    static boolean returnSuccessWithEmptyResult(EsqlExecutionInfo executionInfo, Exception e) {
        if (!executionInfo.isCrossClusterSearch()) {
            return false;
        }
        if (e instanceof NoClustersToSearchException || ExceptionsHelper.isRemoteUnavailableException((Exception)e)) {
            for (String clusterAlias : executionInfo.clusterAliases()) {
                if (executionInfo.isSkipUnavailable(clusterAlias) || clusterAlias.equals("")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static void updateExecutionInfoToReturnEmptyResult(EsqlExecutionInfo executionInfo, Exception e) {
        executionInfo.markEndQuery();
        Exception exceptionForResponse = e instanceof ConnectTransportException ? new RemoteTransportException("connect_transport_exception - unable to connect to remote cluster", null) : e;
        for (String clusterAlias : executionInfo.clusterAliases()) {
            executionInfo.swapCluster(clusterAlias, (k, v) -> {
                EsqlExecutionInfo.Cluster.Builder builder = new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setTook(executionInfo.overallTook()).setTotalShards(0).setSuccessfulShards(0).setSkippedShards(0).setFailedShards(0);
                if ("".equals(clusterAlias)) {
                    builder.setStatus(EsqlExecutionInfo.Cluster.Status.SUCCESSFUL);
                } else {
                    builder.setStatus(EsqlExecutionInfo.Cluster.Status.SKIPPED);
                    if (v.getFailures() == null || v.getFailures().size() == 0) {
                        builder.setFailures(List.of(new ShardSearchFailure(exceptionForResponse)));
                    }
                }
                return builder.build();
            });
        }
    }

    static String createIndexExpressionFromAvailableClusters(EsqlExecutionInfo executionInfo) {
        StringBuilder sb = new StringBuilder();
        for (String clusterAlias : executionInfo.clusterAliases()) {
            EsqlExecutionInfo.Cluster cluster = executionInfo.getCluster(clusterAlias);
            if (cluster.getStatus() == EsqlExecutionInfo.Cluster.Status.SKIPPED) continue;
            if (cluster.getClusterAlias().equals("")) {
                sb.append(executionInfo.getCluster(clusterAlias).getIndexExpression()).append(',');
                continue;
            }
            String indexExpression = executionInfo.getCluster(clusterAlias).getIndexExpression();
            for (String index : indexExpression.split(",")) {
                sb.append(clusterAlias).append(':').append(index).append(',');
            }
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    static void updateExecutionInfoWithUnavailableClusters(EsqlExecutionInfo execInfo, Map<String, FieldCapabilitiesFailure> unavailable) {
        for (Map.Entry<String, FieldCapabilitiesFailure> entry : unavailable.entrySet()) {
            String clusterAlias = entry.getKey();
            boolean skipUnavailable = execInfo.getCluster(clusterAlias).isSkipUnavailable();
            RemoteTransportException e = new RemoteTransportException(Strings.format((String)"Remote cluster [%s] (with setting skip_unavailable=%s) is not available", (Object[])new Object[]{clusterAlias, skipUnavailable}), (Throwable)entry.getValue().getException());
            if (skipUnavailable) {
                execInfo.swapCluster(clusterAlias, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setStatus(EsqlExecutionInfo.Cluster.Status.SKIPPED).setTotalShards(0).setSuccessfulShards(0).setSkippedShards(0).setFailedShards(0).setFailures(List.of(new ShardSearchFailure((Exception)e))).build());
                continue;
            }
            throw e;
        }
    }

    static void updateExecutionInfoWithClustersWithNoMatchingIndices(EsqlExecutionInfo executionInfo, IndexResolution indexResolution) {
        HashSet<String> clustersWithResolvedIndices = new HashSet<String>();
        for (String indexName : indexResolution.resolvedIndices()) {
            clustersWithResolvedIndices.add(RemoteClusterAware.parseClusterAlias((String)indexName));
        }
        Set<String> clustersRequested = executionInfo.clusterAliases();
        Set clustersWithNoMatchingIndices = Sets.difference(clustersRequested, clustersWithResolvedIndices);
        clustersWithNoMatchingIndices.removeAll(indexResolution.unavailableClusters().keySet());
        Object fatalErrorMessage = null;
        for (String c : clustersWithNoMatchingIndices) {
            ShardSearchFailure failure;
            EsqlExecutionInfo.Cluster.Status status;
            if (executionInfo.getCluster(c).getStatus() == EsqlExecutionInfo.Cluster.Status.SKIPPED) continue;
            String indexExpression = executionInfo.getCluster(c).getIndexExpression();
            if (EsqlSessionCCSUtils.missingIndicesIsFatal(c, executionInfo)) {
                String error = Strings.format((String)"Unknown index [%s]", (Object[])new Object[]{c.equals("") ? indexExpression : c + ":" + indexExpression});
                if (fatalErrorMessage == null) {
                    fatalErrorMessage = error;
                    continue;
                }
                fatalErrorMessage = (String)fatalErrorMessage + "; " + error;
                continue;
            }
            if (c.equals("")) {
                status = EsqlExecutionInfo.Cluster.Status.SUCCESSFUL;
                failure = null;
            } else {
                status = EsqlExecutionInfo.Cluster.Status.SKIPPED;
                failure = new ShardSearchFailure((Exception)((Object)new VerificationException("Unknown index [" + indexExpression + "]", new Object[0])));
            }
            executionInfo.swapCluster(c, (k, v) -> {
                EsqlExecutionInfo.Cluster.Builder builder = new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setStatus(status).setTook(new TimeValue(0L)).setTotalShards(0).setSuccessfulShards(0).setSkippedShards(0).setFailedShards(0);
                if (failure != null) {
                    builder.setFailures(List.of(failure));
                }
                return builder.build();
            });
        }
        if (fatalErrorMessage != null) {
            throw new VerificationException((String)fatalErrorMessage, new Object[0]);
        }
    }

    static boolean missingIndicesIsFatal(String clusterAlias, EsqlExecutionInfo executionInfo) {
        if (clusterAlias.equals("")) {
            return EsqlSessionCCSUtils.concreteIndexRequested(executionInfo.getCluster(clusterAlias).getIndexExpression());
        }
        return !executionInfo.getCluster(clusterAlias).isSkipUnavailable();
    }

    private static boolean concreteIndexRequested(String indexExpression) {
        for (String expr : indexExpression.split(",")) {
            if (expr.charAt(0) == '<' || expr.startsWith("-<") || expr.indexOf(42) >= 0) continue;
            return true;
        }
        return false;
    }

    static void updateExecutionInfoAtEndOfPlanning(EsqlExecutionInfo execInfo) {
        if (execInfo.isCrossClusterSearch()) {
            execInfo.markEndPlanning();
            for (String clusterAlias : execInfo.clusterAliases()) {
                EsqlExecutionInfo.Cluster cluster = execInfo.getCluster(clusterAlias);
                if (cluster.getStatus() != EsqlExecutionInfo.Cluster.Status.SKIPPED) continue;
                execInfo.swapCluster(clusterAlias, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setTook(execInfo.planningTookTime()).setTotalShards(0).setSuccessfulShards(0).setSkippedShards(0).setFailedShards(0).build());
            }
        }
    }

    static abstract class CssPartialErrorsActionListener
    implements ActionListener<LogicalPlan> {
        private final EsqlExecutionInfo executionInfo;
        private final ActionListener<Result> listener;

        CssPartialErrorsActionListener(EsqlExecutionInfo executionInfo, ActionListener<Result> listener) {
            this.executionInfo = executionInfo;
            this.listener = listener;
        }

        public void onFailure(Exception e) {
            if (EsqlSessionCCSUtils.returnSuccessWithEmptyResult(this.executionInfo, e)) {
                EsqlSessionCCSUtils.updateExecutionInfoToReturnEmptyResult(this.executionInfo, e);
                this.listener.onResponse((Object)new Result(Analyzer.NO_FIELDS, Collections.emptyList(), Collections.emptyList(), this.executionInfo));
            } else {
                this.listener.onFailure(e);
            }
        }
    }
}

