/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceProvider;

final class ReinitializingSourceProvider
implements SourceProvider {
    private PerThreadSourceProvider perThreadProvider;
    private final Supplier<SourceProvider> sourceProviderFactory;
    private int lastSeenDocId;

    ReinitializingSourceProvider(Supplier<SourceProvider> sourceProviderFactory) {
        this.sourceProviderFactory = sourceProviderFactory;
    }

    public Source getSource(LeafReaderContext ctx, int doc) throws IOException {
        Thread currentThread = Thread.currentThread();
        PerThreadSourceProvider provider = this.perThreadProvider;
        if (provider == null || provider.creatingThread != currentThread || doc < this.lastSeenDocId) {
            this.perThreadProvider = provider = new PerThreadSourceProvider(this.sourceProviderFactory.get(), currentThread);
        }
        this.lastSeenDocId = doc;
        return provider.source.getSource(ctx, doc);
    }

    private record PerThreadSourceProvider(SourceProvider source, Thread creatingThread) {
    }
}

