/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.transport.TransportResponse;

final class ComputeResponse
extends TransportResponse {
    private final List<DriverProfile> profiles;
    private final TimeValue took;
    public final int totalShards;
    public final int successfulShards;
    public final int skippedShards;
    public final int failedShards;

    ComputeResponse(List<DriverProfile> profiles) {
        this(profiles, null, null, null, null, null);
    }

    ComputeResponse(List<DriverProfile> profiles, TimeValue took, Integer totalShards, Integer successfulShards, Integer skippedShards, Integer failedShards) {
        this.profiles = profiles;
        this.took = took;
        this.totalShards = totalShards == null ? 0 : totalShards;
        this.successfulShards = successfulShards == null ? 0 : successfulShards;
        this.skippedShards = skippedShards == null ? 0 : skippedShards;
        this.failedShards = failedShards == null ? 0 : failedShards;
    }

    ComputeResponse(StreamInput in) throws IOException {
        super(in);
        this.profiles = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0) ? (in.readBoolean() ? in.readCollectionAsImmutableList(DriverProfile::new) : null) : null;
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_CCS_EXECUTION_INFO)) {
            this.took = in.readOptionalTimeValue();
            this.totalShards = in.readVInt();
            this.successfulShards = in.readVInt();
            this.skippedShards = in.readVInt();
            this.failedShards = in.readVInt();
        } else {
            this.took = new TimeValue(0L);
            this.totalShards = 0;
            this.successfulShards = 0;
            this.skippedShards = 0;
            this.failedShards = 0;
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
            if (this.profiles == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeCollection(this.profiles);
            }
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_CCS_EXECUTION_INFO)) {
            out.writeOptionalTimeValue(this.took);
            out.writeVInt(this.totalShards);
            out.writeVInt(this.successfulShards);
            out.writeVInt(this.skippedShards);
            out.writeVInt(this.failedShards);
        }
    }

    public List<DriverProfile> getProfiles() {
        return this.profiles;
    }

    public TimeValue getTook() {
        return this.took;
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getSkippedShards() {
        return this.skippedShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }
}

