/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.Describable;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LocalCircuitBreaker;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.LuceneCountOperator;
import org.elasticsearch.compute.operator.ColumnExtractOperator;
import org.elasticsearch.compute.operator.ColumnLoadOperator;
import org.elasticsearch.compute.operator.Driver;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.FilterOperator;
import org.elasticsearch.compute.operator.LimitOperator;
import org.elasticsearch.compute.operator.LocalSourceOperator;
import org.elasticsearch.compute.operator.MvExpandOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.OutputOperator;
import org.elasticsearch.compute.operator.ProjectOperator;
import org.elasticsearch.compute.operator.RowInTableLookupOperator;
import org.elasticsearch.compute.operator.RowOperator;
import org.elasticsearch.compute.operator.ShowOperator;
import org.elasticsearch.compute.operator.SinkOperator;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.compute.operator.StringExtractOperator;
import org.elasticsearch.compute.operator.exchange.ExchangeSinkHandler;
import org.elasticsearch.compute.operator.exchange.ExchangeSinkOperator;
import org.elasticsearch.compute.operator.exchange.ExchangeSourceHandler;
import org.elasticsearch.compute.operator.exchange.ExchangeSourceOperator;
import org.elasticsearch.compute.operator.topn.TopNEncoder;
import org.elasticsearch.compute.operator.topn.TopNOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.enrich.EnrichLookupOperator;
import org.elasticsearch.xpack.esql.enrich.EnrichLookupService;
import org.elasticsearch.xpack.esql.enrich.LookupFromIndexOperator;
import org.elasticsearch.xpack.esql.enrich.LookupFromIndexService;
import org.elasticsearch.xpack.esql.evaluator.EvalMapper;
import org.elasticsearch.xpack.esql.evaluator.command.GrokEvaluatorExtracter;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.DissectExec;
import org.elasticsearch.xpack.esql.plan.physical.EnrichExec;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EsStatsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.GrokExec;
import org.elasticsearch.xpack.esql.plan.physical.HashJoinExec;
import org.elasticsearch.xpack.esql.plan.physical.LimitExec;
import org.elasticsearch.xpack.esql.plan.physical.LocalSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.LookupJoinExec;
import org.elasticsearch.xpack.esql.plan.physical.MvExpandExec;
import org.elasticsearch.xpack.esql.plan.physical.OutputExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.ProjectExec;
import org.elasticsearch.xpack.esql.plan.physical.RowExec;
import org.elasticsearch.xpack.esql.plan.physical.ShowExec;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;
import org.elasticsearch.xpack.esql.planner.EsPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.ExchangeLayout;
import org.elasticsearch.xpack.esql.planner.Layout;
import org.elasticsearch.xpack.esql.planner.PhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class LocalExecutionPlanner {
    private static final Logger logger = LogManager.getLogger(LocalExecutionPlanner.class);
    private final String sessionId;
    private final String clusterAlias;
    private final CancellableTask parentTask;
    private final BigArrays bigArrays;
    private final BlockFactory blockFactory;
    private final Settings settings;
    private final Configuration configuration;
    private final ExchangeSourceHandler exchangeSourceHandler;
    private final ExchangeSinkHandler exchangeSinkHandler;
    private final EnrichLookupService enrichLookupService;
    private final LookupFromIndexService lookupFromIndexService;
    private final PhysicalOperationProviders physicalOperationProviders;

    public LocalExecutionPlanner(String sessionId, String clusterAlias, CancellableTask parentTask, BigArrays bigArrays, BlockFactory blockFactory, Settings settings, Configuration configuration, ExchangeSourceHandler exchangeSourceHandler, ExchangeSinkHandler exchangeSinkHandler, EnrichLookupService enrichLookupService, LookupFromIndexService lookupFromIndexService, PhysicalOperationProviders physicalOperationProviders) {
        this.sessionId = sessionId;
        this.clusterAlias = clusterAlias;
        this.parentTask = parentTask;
        this.bigArrays = bigArrays;
        this.blockFactory = blockFactory;
        this.settings = settings;
        this.exchangeSourceHandler = exchangeSourceHandler;
        this.exchangeSinkHandler = exchangeSinkHandler;
        this.enrichLookupService = enrichLookupService;
        this.lookupFromIndexService = lookupFromIndexService;
        this.physicalOperationProviders = physicalOperationProviders;
        this.configuration = configuration;
    }

    public LocalExecutionPlan plan(PhysicalPlan localPhysicalPlan) {
        LocalExecutionPlannerContext context = new LocalExecutionPlannerContext(new ArrayList<DriverFactory>(), (Holder<DriverParallelism>)new Holder((Object)DriverParallelism.SINGLE), this.configuration.pragmas(), this.bigArrays, this.blockFactory, this.settings);
        localPhysicalPlan = (PhysicalPlan)localPhysicalPlan.transformUp(AggregateExec.class, a -> a.getMode() == AggregatorMode.FINAL ? new ProjectExec(a.source(), (PhysicalPlan)((Object)a), Expressions.asAttributes(a.aggregates())) : a);
        PhysicalOperation physicalOperation = this.plan(localPhysicalPlan, context);
        TimeValue statusInterval = this.configuration.pragmas().statusInterval();
        context.addDriverFactory(new DriverFactory(new DriverSupplier(context.bigArrays, context.blockFactory, physicalOperation, statusInterval, this.settings), (DriverParallelism)context.driverParallelism().get()));
        return new LocalExecutionPlan(context.driverFactories);
    }

    private PhysicalOperation plan(PhysicalPlan node, LocalExecutionPlannerContext context) {
        if (node instanceof AggregateExec) {
            AggregateExec aggregate = (AggregateExec)node;
            return this.planAggregation(aggregate, context);
        }
        if (node instanceof FieldExtractExec) {
            FieldExtractExec fieldExtractExec = (FieldExtractExec)node;
            return this.planFieldExtractNode(fieldExtractExec, context);
        }
        if (node instanceof ExchangeExec) {
            ExchangeExec exchangeExec = (ExchangeExec)node;
            return this.planExchange(exchangeExec, context);
        }
        if (node instanceof TopNExec) {
            TopNExec topNExec = (TopNExec)node;
            return this.planTopN(topNExec, context);
        }
        if (node instanceof EvalExec) {
            EvalExec eval = (EvalExec)node;
            return this.planEval(eval, context);
        }
        if (node instanceof DissectExec) {
            DissectExec dissect = (DissectExec)node;
            return this.planDissect(dissect, context);
        }
        if (node instanceof GrokExec) {
            GrokExec grok = (GrokExec)node;
            return this.planGrok(grok, context);
        }
        if (node instanceof ProjectExec) {
            ProjectExec project = (ProjectExec)node;
            return this.planProject(project, context);
        }
        if (node instanceof FilterExec) {
            FilterExec filter = (FilterExec)node;
            return this.planFilter(filter, context);
        }
        if (node instanceof LimitExec) {
            LimitExec limit = (LimitExec)node;
            return this.planLimit(limit, context);
        }
        if (node instanceof MvExpandExec) {
            MvExpandExec mvExpand = (MvExpandExec)node;
            return this.planMvExpand(mvExpand, context);
        }
        if (node instanceof EsQueryExec) {
            EsQueryExec esQuery = (EsQueryExec)node;
            return this.planEsQueryNode(esQuery, context);
        }
        if (node instanceof EsStatsQueryExec) {
            EsStatsQueryExec statsQuery = (EsStatsQueryExec)node;
            return this.planEsStats(statsQuery, context);
        }
        if (node instanceof RowExec) {
            RowExec row = (RowExec)node;
            return this.planRow(row, context);
        }
        if (node instanceof LocalSourceExec) {
            LocalSourceExec localSource = (LocalSourceExec)node;
            return this.planLocal(localSource, context);
        }
        if (node instanceof ShowExec) {
            ShowExec show = (ShowExec)node;
            return this.planShow(show);
        }
        if (node instanceof ExchangeSourceExec) {
            ExchangeSourceExec exchangeSource = (ExchangeSourceExec)node;
            return this.planExchangeSource(exchangeSource, context);
        }
        if (node instanceof EnrichExec) {
            EnrichExec enrich = (EnrichExec)node;
            return this.planEnrich(enrich, context);
        }
        if (node instanceof HashJoinExec) {
            HashJoinExec join = (HashJoinExec)node;
            return this.planHashJoin(join, context);
        }
        if (node instanceof LookupJoinExec) {
            LookupJoinExec join = (LookupJoinExec)node;
            return this.planLookupJoin(join, context);
        }
        if (node instanceof OutputExec) {
            OutputExec outputExec = (OutputExec)node;
            return this.planOutput(outputExec, context);
        }
        if (node instanceof ExchangeSinkExec) {
            ExchangeSinkExec exchangeSink = (ExchangeSinkExec)node;
            return this.planExchangeSink(exchangeSink, context);
        }
        throw new EsqlIllegalArgumentException("unknown physical plan node [" + node.nodeName() + "]");
    }

    private PhysicalOperation planAggregation(AggregateExec aggregate, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(aggregate.child(), context);
        return this.physicalOperationProviders.groupingPhysicalOperation(aggregate, source, context);
    }

    private PhysicalOperation planEsQueryNode(EsQueryExec esQueryExec, LocalExecutionPlannerContext context) {
        return this.physicalOperationProviders.sourcePhysicalOperation(esQueryExec, context);
    }

    private PhysicalOperation planEsStats(EsStatsQueryExec statsQuery, LocalExecutionPlannerContext context) {
        if (!(this.physicalOperationProviders instanceof EsPhysicalOperationProviders)) {
            throw new EsqlIllegalArgumentException("EsStatsQuery should only occur against a Lucene backend");
        }
        if (statsQuery.stats().size() > 1) {
            throw new EsqlIllegalArgumentException("EsStatsQuery currently supports only one field statistic");
        }
        EsStatsQueryExec.Stat stat = statsQuery.stats().get(0);
        EsPhysicalOperationProviders esProvider = (EsPhysicalOperationProviders)this.physicalOperationProviders;
        LuceneCountOperator.Factory luceneFactory = esProvider.countSource(context, stat.filter(statsQuery.query()), statsQuery.limit());
        Layout.Builder layout = new Layout.Builder();
        layout.append((Collection<? extends NamedExpression>)statsQuery.outputSet());
        int instanceCount = Math.max(1, luceneFactory.taskConcurrency());
        context.driverParallelism(new DriverParallelism(DriverParallelism.Type.DATA_PARALLELISM, instanceCount));
        return PhysicalOperation.fromSource((SourceOperator.SourceOperatorFactory)luceneFactory, layout.build());
    }

    private PhysicalOperation planFieldExtractNode(FieldExtractExec fieldExtractExec, LocalExecutionPlannerContext context) {
        return this.physicalOperationProviders.fieldExtractPhysicalOperation(fieldExtractExec, this.plan(fieldExtractExec.child(), context));
    }

    private PhysicalOperation planOutput(OutputExec outputExec, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(outputExec.child(), context);
        List<Attribute> output = outputExec.output();
        return source.withSink((SinkOperator.SinkOperatorFactory)new OutputOperator.OutputOperatorFactory(Expressions.names(output), LocalExecutionPlanner.alignPageToAttributes(output, source.layout), outputExec.getPageConsumer()), source.layout);
    }

    private static Function<Page, Page> alignPageToAttributes(List<Attribute> attrs, Layout layout) {
        int[] mappedPosition = new int[attrs.size()];
        int index = -1;
        boolean transformRequired = false;
        for (Attribute attribute : attrs) {
            mappedPosition[++index] = layout.get(attribute.id()).channel();
            transformRequired |= mappedPosition[index] != index;
        }
        Function<Page, Page> transformer = transformRequired ? p -> {
            Block[] blocks = new Block[mappedPosition.length];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = p.getBlock(mappedPosition[i]);
                blocks[i].incRef();
            }
            p.releaseBlocks();
            return new Page(blocks);
        } : Function.identity();
        return transformer;
    }

    private PhysicalOperation planExchange(ExchangeExec exchangeExec, LocalExecutionPlannerContext context) {
        throw new UnsupportedOperationException("Exchange needs to be replaced with a sink/source");
    }

    private PhysicalOperation planExchangeSink(ExchangeSinkExec exchangeSink, LocalExecutionPlannerContext context) {
        Objects.requireNonNull(this.exchangeSinkHandler, "ExchangeSinkHandler wasn't provided");
        PhysicalPlan child = exchangeSink.child();
        PhysicalOperation source = this.plan(child, context);
        Function transformer = exchangeSink.isIntermediateAgg() ? Function.identity() : LocalExecutionPlanner.alignPageToAttributes(exchangeSink.output(), source.layout);
        return source.withSink((SinkOperator.SinkOperatorFactory)new ExchangeSinkOperator.ExchangeSinkOperatorFactory(() -> ((ExchangeSinkHandler)this.exchangeSinkHandler).createExchangeSink(), transformer), source.layout);
    }

    private PhysicalOperation planExchangeSource(ExchangeSourceExec exchangeSource, LocalExecutionPlannerContext context) {
        Objects.requireNonNull(this.exchangeSourceHandler, "ExchangeSourceHandler wasn't provided");
        Layout.Builder builder = new Layout.Builder();
        builder.append(exchangeSource.output());
        Layout l = builder.build();
        Layout layout = exchangeSource.isIntermediateAgg() ? new ExchangeLayout(l) : l;
        return PhysicalOperation.fromSource((SourceOperator.SourceOperatorFactory)new ExchangeSourceOperator.ExchangeSourceOperatorFactory(() -> ((ExchangeSourceHandler)this.exchangeSourceHandler).createExchangeSource()), layout);
    }

    private PhysicalOperation planTopN(TopNExec topNExec, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(topNExec.child(), context);
        ElementType[] elementTypes = new ElementType[source.layout.numberOfChannels()];
        TopNEncoder[] encoders = new TopNEncoder[source.layout.numberOfChannels()];
        List<Layout.ChannelSet> inverse = source.layout.inverse();
        for (int channel = 0; channel < inverse.size(); ++channel) {
            elementTypes[channel] = PlannerUtils.toElementType(inverse.get(channel).type());
            encoders[channel] = switch (inverse.get(channel).type()) {
                default -> throw new IncompatibleClassChangeError();
                case DataType.IP -> TopNEncoder.IP;
                case DataType.TEXT, DataType.KEYWORD, DataType.SEMANTIC_TEXT -> TopNEncoder.UTF8;
                case DataType.VERSION -> TopNEncoder.VERSION;
                case DataType.BOOLEAN, DataType.NULL, DataType.BYTE, DataType.SHORT, DataType.INTEGER, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.HALF_FLOAT, DataType.DATETIME, DataType.DATE_NANOS, DataType.DATE_PERIOD, DataType.TIME_DURATION, DataType.OBJECT, DataType.SCALED_FLOAT, DataType.UNSIGNED_LONG, DataType.DOC_DATA_TYPE, DataType.TSID_DATA_TYPE -> TopNEncoder.DEFAULT_SORTABLE;
                case DataType.GEO_POINT, DataType.CARTESIAN_POINT, DataType.GEO_SHAPE, DataType.CARTESIAN_SHAPE, DataType.COUNTER_LONG, DataType.COUNTER_INTEGER, DataType.COUNTER_DOUBLE, DataType.SOURCE -> TopNEncoder.DEFAULT_UNSORTABLE;
                case DataType.PARTIAL_AGG, DataType.UNSUPPORTED -> TopNEncoder.UNSUPPORTED;
            };
        }
        List<TopNOperator.SortOrder> orders = topNExec.order().stream().map(order -> {
            Expression patt18943$temp = order.child();
            if (!(patt18943$temp instanceof Attribute)) {
                throw new EsqlIllegalArgumentException("order by expression must be an attribute");
            }
            Attribute a = (Attribute)patt18943$temp;
            int sortByChannel = source.layout.get(a.id()).channel();
            return new TopNOperator.SortOrder(sortByChannel, order.direction().equals((Object)Order.OrderDirection.ASC), order.nullsPosition().equals((Object)Order.NullsPosition.FIRST));
        }).toList();
        Expression expression = topNExec.limit();
        if (!(expression instanceof Literal)) {
            throw new EsqlIllegalArgumentException("limit only supported with literal values");
        }
        Literal literal = (Literal)expression;
        int limit = EsqlDataTypeConverter.stringToInt(literal.value().toString());
        return source.with((Operator.OperatorFactory)new TopNOperator.TopNOperatorFactory(limit, Arrays.asList(elementTypes), Arrays.asList(encoders), orders, context.pageSize(2000 + topNExec.estimatedRowSize())), source.layout);
    }

    private PhysicalOperation planEval(EvalExec eval, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(eval.child(), context);
        for (Alias field : eval.fields()) {
            EvalOperator.ExpressionEvaluator.Factory evaluatorSupplier = EvalMapper.toEvaluator(field.child(), source.layout);
            Layout.Builder layout = source.layout.builder();
            layout.append((NamedExpression)field.toAttribute());
            source = source.with((Operator.OperatorFactory)new EvalOperator.EvalOperatorFactory(evaluatorSupplier), layout.build());
        }
        return source;
    }

    private PhysicalOperation planDissect(DissectExec dissect, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(dissect.child(), context);
        Layout.Builder layoutBuilder = source.layout.builder();
        layoutBuilder.append(dissect.extractedFields());
        Expression expr = dissect.inputExpression();
        String[] patternNames = Expressions.names(dissect.parser().keyAttributes(Source.EMPTY)).toArray(new String[0]);
        Layout layout = layoutBuilder.build();
        source = source.with((Operator.OperatorFactory)new StringExtractOperator.StringExtractOperatorFactory(patternNames, EvalMapper.toEvaluator(expr, layout), () -> input -> dissect.parser().parser().parse(input)), layout);
        return source;
    }

    private PhysicalOperation planGrok(GrokExec grok, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(grok.child(), context);
        Layout.Builder layoutBuilder = source.layout.builder();
        List<Attribute> extractedFields = grok.extractedFields();
        layoutBuilder.append(extractedFields);
        HashMap<String, Integer> fieldToPos = new HashMap<String, Integer>(extractedFields.size());
        HashMap<String, ElementType> fieldToType = new HashMap<String, ElementType>(extractedFields.size());
        ElementType[] types = new ElementType[extractedFields.size()];
        List<Attribute> extractedFieldsFromPattern = grok.pattern().extractedFields();
        for (int i = 0; i < extractedFields.size(); ++i) {
            DataType extractedFieldType = extractedFields.get(i).dataType();
            String patternName = extractedFieldsFromPattern.get(i).name();
            ElementType type = PlannerUtils.toElementType(extractedFieldType);
            fieldToPos.put(patternName, i);
            fieldToType.put(patternName, type);
            types[i] = type;
        }
        Layout layout = layoutBuilder.build();
        source = source.with((Operator.OperatorFactory)new ColumnExtractOperator.Factory(types, EvalMapper.toEvaluator(grok.inputExpression(), layout), () -> new GrokEvaluatorExtracter(grok.pattern().grok(), grok.pattern().pattern(), fieldToPos, fieldToType)), layout);
        return source;
    }

    private PhysicalOperation planEnrich(EnrichExec enrich, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(enrich.child(), context);
        Layout.Builder layoutBuilder = source.layout.builder();
        layoutBuilder.append(enrich.enrichFields());
        Layout layout = layoutBuilder.build();
        String enrichIndex = enrich.concreteIndices().get(this.clusterAlias);
        if (enrichIndex == null) {
            throw new EsqlIllegalArgumentException("No concrete enrich index for cluster [" + this.clusterAlias + "]");
        }
        Layout.ChannelAndType input = source.layout.get(enrich.matchField().id());
        return source.with(new EnrichLookupOperator.Factory(this.sessionId, this.parentTask, context.queryPragmas().enrichMaxWorkers(), input.channel(), this.enrichLookupService, input.type(), enrichIndex, enrich.matchType(), enrich.policyMatchField(), enrich.enrichFields(), enrich.source()), layout);
    }

    private PhysicalOperation planHashJoin(HashJoinExec join, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(join.left(), context);
        int positionsChannel = source.layout.numberOfChannels();
        Layout.Builder layoutBuilder = source.layout.builder();
        for (Attribute f : join.output()) {
            if (join.left().outputSet().contains((Object)f)) continue;
            layoutBuilder.append((NamedExpression)f);
        }
        Layout layout = layoutBuilder.build();
        LocalSourceExec localSourceExec = (LocalSourceExec)join.joinData();
        Block[] localData = (Block[])localSourceExec.supplier().get();
        RowInTableLookupOperator.Key[] keys = new RowInTableLookupOperator.Key[join.leftFields().size()];
        int[] blockMapping = new int[join.leftFields().size()];
        for (int k = 0; k < join.leftFields().size(); ++k) {
            Attribute left = join.leftFields().get(k);
            Attribute right = join.rightFields().get(k);
            Block localField = null;
            List<Attribute> output = join.joinData().output();
            for (int l = 0; l < output.size(); ++l) {
                if (!output.get(l).name().equals(right.name())) continue;
                localField = localData[l];
            }
            if (localField == null) {
                throw new IllegalArgumentException("can't find local data for [" + String.valueOf(right) + "]");
            }
            keys[k] = new RowInTableLookupOperator.Key(left.name(), localField);
            Layout.ChannelAndType input = source.layout.get(left.id());
            blockMapping[k] = input.channel();
        }
        source = source.with((Operator.OperatorFactory)new RowInTableLookupOperator.Factory(keys, blockMapping), layout);
        for (Attribute f : join.addedFields()) {
            Block localField = null;
            for (int l = 0; l < join.joinData().output().size(); ++l) {
                if (!join.joinData().output().get(l).name().equals(f.name())) continue;
                localField = localData[l];
            }
            if (localField == null) {
                throw new IllegalArgumentException("can't find local data for [" + String.valueOf(f) + "]");
            }
            source = source.with((Operator.OperatorFactory)new ColumnLoadOperator.Factory(new ColumnLoadOperator.Values(f.name(), localField), positionsChannel), layout);
        }
        ArrayList projection = new ArrayList();
        IntStream.range(0, positionsChannel).boxed().forEach(projection::add);
        IntStream.range(positionsChannel + 1, positionsChannel + 1 + join.addedFields().size()).boxed().forEach(projection::add);
        return source.with((Operator.OperatorFactory)new ProjectOperator.ProjectOperatorFactory(projection), layout);
    }

    private PhysicalOperation planLookupJoin(LookupJoinExec join, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(join.left(), context);
        Layout.Builder layoutBuilder = source.layout.builder();
        for (Attribute f2 : join.addedFields()) {
            layoutBuilder.append((NamedExpression)f2);
        }
        Layout layout = layoutBuilder.build();
        EsQueryExec localSourceExec = (EsQueryExec)join.lookup();
        if (localSourceExec.indexMode() != IndexMode.LOOKUP) {
            throw new IllegalArgumentException("can't plan [" + String.valueOf(join) + "]");
        }
        ArrayList<Layout.ChannelAndType> matchFields = new ArrayList<Layout.ChannelAndType>(join.matchFields().size());
        for (Attribute m : join.matchFields()) {
            Layout.ChannelAndType t = source.layout.get(m.id());
            if (t == null) {
                throw new IllegalArgumentException("can't plan [" + String.valueOf(join) + "][" + String.valueOf(m) + "]");
            }
            matchFields.add(t);
        }
        if (matchFields.size() != 1) {
            throw new IllegalArgumentException("can't plan [" + String.valueOf(join) + "]");
        }
        return source.with(new LookupFromIndexOperator.Factory(this.sessionId, this.parentTask, context.queryPragmas().enrichMaxWorkers(), ((Layout.ChannelAndType)matchFields.get(0)).channel(), this.lookupFromIndexService, ((Layout.ChannelAndType)matchFields.get(0)).type(), localSourceExec.index().name(), join.matchFields().get(0).name(), join.addedFields().stream().map(f -> f).toList(), join.source()), layout);
    }

    private EvalOperator.ExpressionEvaluator.Factory toEvaluator(Expression exp, Layout layout) {
        return EvalMapper.toEvaluator(exp, layout);
    }

    private PhysicalOperation planRow(RowExec row, LocalExecutionPlannerContext context) {
        List<Object> obj = row.fields().stream().map(f -> f.child().fold()).toList();
        Layout.Builder layout = new Layout.Builder();
        layout.append(row.output());
        return PhysicalOperation.fromSource((SourceOperator.SourceOperatorFactory)new RowOperator.RowOperatorFactory(obj), layout.build());
    }

    private PhysicalOperation planLocal(LocalSourceExec localSourceExec, LocalExecutionPlannerContext context) {
        Layout.Builder layout = new Layout.Builder();
        layout.append(localSourceExec.output());
        LocalSourceOperator.BlockSupplier supplier = () -> (Block[])localSourceExec.supplier().get();
        LocalSourceOperator operator = new LocalSourceOperator(supplier);
        return PhysicalOperation.fromSource((SourceOperator.SourceOperatorFactory)new LocalSourceOperator.LocalSourceFactory(() -> operator), layout.build());
    }

    private PhysicalOperation planShow(ShowExec showExec) {
        Layout.Builder layout = new Layout.Builder();
        layout.append(showExec.output());
        return PhysicalOperation.fromSource((SourceOperator.SourceOperatorFactory)new ShowOperator.ShowOperatorFactory(showExec.values()), layout.build());
    }

    private PhysicalOperation planProject(ProjectExec project, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(project.child(), context);
        List<? extends NamedExpression> projections = project.projections();
        ArrayList<Integer> projectionList = new ArrayList<Integer>(projections.size());
        Layout.Builder layout = new Layout.Builder();
        HashMap inputChannelToOutputIds = new HashMap();
        int size = projections.size();
        for (int index = 0; index < size; ++index) {
            NamedExpression ne = projections.get(index);
            NameId inputId = null;
            if (ne instanceof Alias) {
                Alias a = (Alias)ne;
                inputId = ((NamedExpression)a.child()).id();
            } else {
                inputId = ne.id();
            }
            Layout.ChannelAndType input = source.layout.get(inputId);
            if (input == null) {
                throw new IllegalStateException("can't find input for [" + String.valueOf(ne) + "]");
            }
            Layout.ChannelSet channelSet = (Layout.ChannelSet)inputChannelToOutputIds.get(input.channel());
            if (channelSet == null) {
                channelSet = new Layout.ChannelSet(new HashSet<NameId>(), input.type());
                channelSet.nameIds().add(ne.id());
                layout.append(channelSet);
            } else {
                channelSet.nameIds().add(ne.id());
            }
            if (channelSet.type() != input.type()) {
                throw new IllegalArgumentException("type mismatch for aliases");
            }
            projectionList.add(input.channel());
        }
        return source.with((Operator.OperatorFactory)new ProjectOperator.ProjectOperatorFactory(projectionList), layout.build());
    }

    private PhysicalOperation planFilter(FilterExec filter, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(filter.child(), context);
        return source.with((Operator.OperatorFactory)new FilterOperator.FilterOperatorFactory(this.toEvaluator(filter.condition(), source.layout)), source.layout);
    }

    private PhysicalOperation planLimit(LimitExec limit, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(limit.child(), context);
        return source.with((Operator.OperatorFactory)new LimitOperator.Factory(((Integer)limit.limit().fold()).intValue()), source.layout);
    }

    private PhysicalOperation planMvExpand(MvExpandExec mvExpandExec, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(mvExpandExec.child(), context);
        int blockSize = 5000;
        Layout.Builder layout = source.layout.builder();
        layout.replace(mvExpandExec.target().id(), mvExpandExec.expanded().id());
        return source.with((Operator.OperatorFactory)new MvExpandOperator.Factory(source.layout.get(mvExpandExec.target().id()).channel(), blockSize), layout.build());
    }

    public record LocalExecutionPlannerContext(List<DriverFactory> driverFactories, Holder<DriverParallelism> driverParallelism, QueryPragmas queryPragmas, BigArrays bigArrays, BlockFactory blockFactory, Settings settings) {
        void addDriverFactory(DriverFactory driverFactory) {
            this.driverFactories.add(driverFactory);
        }

        void driverParallelism(DriverParallelism parallelism) {
            this.driverParallelism.set((Object)parallelism);
        }

        int pageSize(Integer estimatedRowSize) {
            if (estimatedRowSize == null) {
                throw new IllegalStateException("estimated row size hasn't been set");
            }
            if (estimatedRowSize == 0) {
                throw new IllegalStateException("estimated row size can't be 0");
            }
            if (this.queryPragmas.pageSize() != 0) {
                return this.queryPragmas.pageSize();
            }
            return Math.max(32, SourceOperator.TARGET_PAGE_SIZE / estimatedRowSize);
        }
    }

    record DriverParallelism(Type type, int instanceCount) {
        static final DriverParallelism SINGLE = new DriverParallelism(Type.SINGLETON, 1);

        DriverParallelism {
            if (instanceCount <= 0) {
                throw new IllegalArgumentException("instance count must be greater than zero; got: " + instanceCount);
            }
        }

        static enum Type {
            SINGLETON,
            DATA_PARALLELISM,
            TASK_LEVEL_PARALLELISM;

        }
    }

    public static class PhysicalOperation
    implements Describable {
        final SourceOperator.SourceOperatorFactory sourceOperatorFactory;
        final List<Operator.OperatorFactory> intermediateOperatorFactories;
        final SinkOperator.SinkOperatorFactory sinkOperatorFactory;
        final Layout layout;

        static PhysicalOperation fromSource(SourceOperator.SourceOperatorFactory sourceOperatorFactory, Layout layout) {
            return new PhysicalOperation(sourceOperatorFactory, layout);
        }

        PhysicalOperation with(Layout layout) {
            return new PhysicalOperation(this, Optional.empty(), Optional.empty(), layout);
        }

        PhysicalOperation with(Operator.OperatorFactory operatorFactory, Layout layout) {
            return new PhysicalOperation(this, Optional.of(operatorFactory), Optional.empty(), layout);
        }

        PhysicalOperation withSink(SinkOperator.SinkOperatorFactory sink, Layout layout) {
            return new PhysicalOperation(this, Optional.empty(), Optional.of(sink), layout);
        }

        private PhysicalOperation(SourceOperator.SourceOperatorFactory sourceOperatorFactory, Layout layout) {
            this.sourceOperatorFactory = sourceOperatorFactory;
            this.intermediateOperatorFactories = List.of();
            this.sinkOperatorFactory = null;
            this.layout = layout;
        }

        private PhysicalOperation(PhysicalOperation physicalOperation, Optional<Operator.OperatorFactory> intermediateOperatorFactory, Optional<SinkOperator.SinkOperatorFactory> sinkOperatorFactory, Layout layout) {
            this.sourceOperatorFactory = physicalOperation.sourceOperatorFactory;
            this.intermediateOperatorFactories = new ArrayList<Operator.OperatorFactory>();
            this.intermediateOperatorFactories.addAll(physicalOperation.intermediateOperatorFactories);
            intermediateOperatorFactory.ifPresent(this.intermediateOperatorFactories::add);
            this.sinkOperatorFactory = sinkOperatorFactory.isPresent() ? sinkOperatorFactory.get() : null;
            this.layout = layout;
        }

        public SourceOperator source(DriverContext driverContext) {
            return this.sourceOperatorFactory.get(driverContext);
        }

        public void operators(List<Operator> operators, DriverContext driverContext) {
            this.intermediateOperatorFactories.stream().map(opFactory -> opFactory.get(driverContext)).forEach(operators::add);
        }

        public SinkOperator sink(DriverContext driverContext) {
            return this.sinkOperatorFactory.get(driverContext);
        }

        public String describe() {
            return Stream.concat(Stream.concat(Stream.of(this.sourceOperatorFactory), this.intermediateOperatorFactories.stream()), Stream.of(this.sinkOperatorFactory)).map(Describable::describe).collect(Collectors.joining("\n\\_", "\\_", ""));
        }

        public String toString() {
            return this.describe();
        }
    }

    record DriverFactory(DriverSupplier driverSupplier, DriverParallelism driverParallelism) implements Describable
    {
        public String describe() {
            return "DriverFactory(instances = " + this.driverParallelism.instanceCount() + ", type = " + String.valueOf((Object)this.driverParallelism.type()) + ")\n" + this.driverSupplier.describe();
        }
    }

    record DriverSupplier(BigArrays bigArrays, BlockFactory blockFactory, PhysicalOperation physicalOperation, TimeValue statusInterval, Settings settings) implements Function<String, Driver>,
    Describable
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Driver apply(String sessionId) {
            Driver driver;
            block3: {
                SourceOperator source = null;
                ArrayList<Operator> operators = new ArrayList<Operator>();
                SinkOperator sink = null;
                boolean success = false;
                LocalCircuitBreaker.SizeSettings localBreakerSettings = new LocalCircuitBreaker.SizeSettings(this.settings);
                LocalCircuitBreaker localBreaker = new LocalCircuitBreaker(this.blockFactory.breaker(), localBreakerSettings.overReservedBytes(), localBreakerSettings.maxOverReservedBytes());
                DriverContext driverContext = new DriverContext(this.bigArrays, this.blockFactory.newChildFactory(localBreaker));
                try {
                    source = this.physicalOperation.source(driverContext);
                    this.physicalOperation.operators(operators, driverContext);
                    sink = this.physicalOperation.sink(driverContext);
                    success = true;
                    driver = new Driver(sessionId, System.currentTimeMillis(), System.nanoTime(), driverContext, this.physicalOperation::describe, source, operators, sink, this.statusInterval, (Releasable)localBreaker);
                    if (success) break block3;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        Releasables.close((Releasable[])new Releasable[]{source, () -> Releasables.close((Iterable)operators), sink, localBreaker});
                    }
                    throw throwable;
                }
                Releasables.close((Releasable[])new Releasable[]{source, () -> Releasables.close((Iterable)operators), sink, localBreaker});
            }
            return driver;
        }

        public String describe() {
            return this.physicalOperation.describe();
        }
    }

    public static class LocalExecutionPlan
    implements Describable {
        final List<DriverFactory> driverFactories;

        LocalExecutionPlan(List<DriverFactory> driverFactories) {
            this.driverFactories = driverFactories;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Driver> createDrivers(String sessionId) {
            ArrayList<Driver> drivers = new ArrayList<Driver>();
            boolean success = false;
            try {
                for (DriverFactory df : this.driverFactories) {
                    for (int i = 0; i < df.driverParallelism.instanceCount; ++i) {
                        logger.trace("building {} {}", new Object[]{i, df});
                        drivers.add(df.driverSupplier.apply(sessionId));
                    }
                }
                success = true;
                ArrayList<Driver> arrayList = drivers;
                return arrayList;
            }
            finally {
                if (!success) {
                    Releasables.close((Releasable)Releasables.wrap(drivers));
                }
            }
        }

        public String describe() {
            return this.driverFactories.stream().map(DriverFactory::describe).collect(Collectors.joining("\n"));
        }
    }
}

