/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.BinaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;

public class Join
extends BinaryPlan {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "Join", Join::new);
    private final JoinConfig config;
    private List<Attribute> lazyOutput;

    public Join(Source source, LogicalPlan left, LogicalPlan right, JoinConfig config) {
        super(source, left, right);
        this.config = config;
    }

    public Join(Source source, LogicalPlan left, LogicalPlan right, JoinType type, List<Attribute> matchFields, List<Attribute> leftFields, List<Attribute> rightFields) {
        super(source, left, right);
        this.config = new JoinConfig(type, matchFields, leftFields, rightFields);
    }

    public Join(StreamInput in) throws IOException {
        super(Source.readFrom((StreamInput)((PlanStreamInput)in)), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class));
        this.config = new JoinConfig(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.left());
        out.writeNamedWriteable((NamedWriteable)this.right());
        this.config.writeTo(out);
    }

    public String getWriteableName() {
        return Join.ENTRY.name;
    }

    public JoinConfig config() {
        return this.config;
    }

    protected NodeInfo<Join> info() {
        return NodeInfo.create((Node)this, Join::new, (Object)((Object)this.left()), (Object)((Object)this.right()), (Object)this.config.type(), this.config.matchFields(), this.config.leftFields(), this.config.rightFields());
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = Join.computeOutput(this.left().output(), this.right().output(), this.config);
        }
        return this.lazyOutput;
    }

    public static List<Attribute> computeOutput(List<Attribute> leftOutput, List<Attribute> rightOutput, JoinConfig config) {
        List<Attribute> output;
        JoinType joinType = config.type();
        if (JoinTypes.LEFT.equals(joinType)) {
            output = Join.merge(leftOutput, rightOutput);
        } else if (JoinTypes.RIGHT.equals(joinType)) {
            output = Join.merge(leftOutput, rightOutput);
        } else {
            throw new IllegalArgumentException(joinType.joinName() + " unsupported");
        }
        return output;
    }

    private static List<Attribute> merge(List<Attribute> left, List<Attribute> right) {
        LinkedHashMap nameToAttribute = Maps.newLinkedHashMapWithExpectedSize((int)(left.size() + right.size()));
        for (Attribute a : left) {
            nameToAttribute.put(a.name(), a);
        }
        for (Attribute a : right) {
            nameToAttribute.compute(a.name(), (name, existing) -> a);
        }
        return new ArrayList<Attribute>(nameToAttribute.values());
    }

    public static List<Attribute> makeReference(List<Attribute> output) {
        ArrayList<Attribute> out = new ArrayList<Attribute>(output.size());
        for (Attribute a : output) {
            if (a.resolved() && !(a instanceof ReferenceAttribute)) {
                out.add((Attribute)new ReferenceAttribute(a.source(), a.name(), a.dataType(), a.nullable(), a.id(), a.synthetic()));
                continue;
            }
            out.add(a);
        }
        return out;
    }

    private static List<Attribute> makeNullable(List<Attribute> output) {
        ArrayList<Attribute> out = new ArrayList<Attribute>(output.size());
        for (Attribute a : output) {
            out.add(a.withNullability(Nullability.TRUE));
        }
        return out;
    }

    @Override
    public boolean expressionsResolved() {
        return this.config.expressionsResolved();
    }

    @Override
    public boolean resolved() {
        return this.childrenResolved() && this.expressionsResolved();
    }

    public Join withConfig(JoinConfig config) {
        return new Join(this.source(), this.left(), this.right(), config);
    }

    @Override
    public Join replaceChildren(LogicalPlan left, LogicalPlan right) {
        return new Join(this.source(), left, right, this.config);
    }

    @Override
    public String commandName() {
        return "JOIN";
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.config, this.left(), this.right()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Join other = (Join)((Object)obj);
        return this.config.equals(other.config) && Objects.equals((Object)this.left(), (Object)other.left()) && Objects.equals((Object)this.right(), (Object)other.right());
    }
}

