/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Functions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class Project
extends UnaryPlan {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "Project", Project::new);
    private final List<? extends NamedExpression> projections;

    public Project(Source source, LogicalPlan child, List<? extends NamedExpression> projections) {
        super(source, child);
        this.projections = projections;
    }

    private Project(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), in.readNamedWriteableCollectionAsList(NamedExpression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteableCollection(this.projections());
    }

    public String getWriteableName() {
        return Project.ENTRY.name;
    }

    protected NodeInfo<Project> info() {
        return NodeInfo.create((Node)this, Project::new, (Object)((Object)this.child()), this.projections);
    }

    @Override
    public Project replaceChild(LogicalPlan newChild) {
        return new Project(this.source(), newChild, this.projections);
    }

    public List<? extends NamedExpression> projections() {
        return this.projections;
    }

    public Project withProjections(List<? extends NamedExpression> projections) {
        return new Project(this.source(), this.child(), projections);
    }

    @Override
    public boolean resolved() {
        return super.resolved() && !Expressions.anyMatch(this.projections, Functions::isAggregate);
    }

    @Override
    public String commandName() {
        return "<project>";
    }

    @Override
    public boolean expressionsResolved() {
        return Resolvables.resolved(this.projections);
    }

    @Override
    public List<Attribute> output() {
        return Expressions.asAttributes(this.projections);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.projections, this.child()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)((Object)obj);
        return Objects.equals(this.projections, other.projections) && Objects.equals((Object)this.child(), (Object)other.child());
    }
}

