/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;

public final class PushDownAndCombineLimits
extends OptimizerRules.OptimizerRule<Limit> {
    @Override
    public LogicalPlan rule(Limit limit) {
        LogicalPlan limitSource;
        LogicalPlan logicalPlan = limit.child();
        if (logicalPlan instanceof Limit) {
            Limit childLimit = (Limit)logicalPlan;
            limitSource = limit.limit();
            int l1 = (Integer)limitSource.fold();
            int l2 = (Integer)childLimit.limit().fold();
            return new Limit(limit.source(), (Expression)Literal.of((Expression)limitSource, (Object)Math.min(l1, l2)), childLimit.child());
        }
        limitSource = limit.child();
        if (limitSource instanceof UnaryPlan) {
            UnaryPlan unary = (UnaryPlan)limitSource;
            if (unary instanceof Eval || unary instanceof Project || unary instanceof RegexExtract || unary instanceof Enrich) {
                return unary.replaceChild(limit.replaceChild(unary.child()));
            }
            if (unary instanceof MvExpand) {
                MvExpand mvx = (MvExpand)unary;
                Expression limitSource2 = limit.limit();
                int limitVal = (Integer)limitSource2.fold();
                Integer mvxLimit = mvx.limit();
                if (mvxLimit == null || mvxLimit > limitVal) {
                    mvx = new MvExpand(mvx.source(), mvx.child(), mvx.target(), mvx.expanded(), limitVal);
                }
                return mvx.replaceChild(limit.replaceChild(mvx.child()));
            }
            Limit descendantLimit = PushDownAndCombineLimits.descendantLimit(unary);
            if (descendantLimit != null) {
                int l1 = (Integer)limit.limit().fold();
                int l2 = (Integer)descendantLimit.limit().fold();
                if (l2 <= l1) {
                    return new Limit(limit.source(), (Expression)Literal.of((Expression)limit.limit(), (Object)l2), limit.child());
                }
            }
        } else {
            Join join;
            logicalPlan = limit.child();
            if (logicalPlan instanceof Join && (join = (Join)logicalPlan).config().type() == JoinTypes.LEFT && join.right() instanceof LocalRelation) {
                return join.replaceChildren(limit.replaceChild(join.left()), join.right());
            }
        }
        return limit;
    }

    private static Limit descendantLimit(UnaryPlan unary) {
        UnaryPlan plan = unary;
        while (!(plan instanceof Aggregate)) {
            UnaryPlan unaryPlan;
            if (plan instanceof Limit) {
                Limit limit = (Limit)plan;
                return limit;
            }
            if (plan instanceof MvExpand) {
                return null;
            }
            LogicalPlan logicalPlan = plan.child();
            if (!(logicalPlan instanceof UnaryPlan)) break;
            plan = unaryPlan = (UnaryPlan)logicalPlan;
        }
        return null;
    }
}

