/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.EmptyAttribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.rule.Rule;

public final class PruneColumns
extends Rule<LogicalPlan, LogicalPlan> {
    @Override
    public LogicalPlan apply(LogicalPlan plan) {
        AttributeSet used = new AttributeSet();
        Holder seenProjection = new Holder((Object)Boolean.FALSE);
        LogicalPlan pl = (LogicalPlan)plan.transformDown(p -> {
            boolean recheck;
            if (p instanceof Limit) {
                return p;
            }
            do {
                List<? extends NamedExpression> remaining;
                recheck = false;
                if (p instanceof Aggregate) {
                    Aggregate aggregate = (Aggregate)((Object)p);
                    List<? extends NamedExpression> list = remaining = (Boolean)seenProjection.get() != false ? PruneColumns.removeUnused(aggregate.aggregates(), used) : null;
                    if (remaining != null) {
                        if (remaining.isEmpty()) {
                            if (aggregate.groupings().isEmpty()) {
                                p = new LocalRelation(aggregate.source(), List.of(new EmptyAttribute(aggregate.source())), LocalSupplier.of(new Block[]{BlockUtils.constantBlock((BlockFactory)PlannerUtils.NON_BREAKING_BLOCK_FACTORY, null, (int)1)}));
                            } else {
                                remaining = List.of(Expressions.attribute((Expression)aggregate.groupings().get(0)));
                                p = new Aggregate(aggregate.source(), aggregate.child(), aggregate.aggregateType(), aggregate.groupings(), remaining);
                            }
                        } else {
                            p = new Aggregate(aggregate.source(), aggregate.child(), aggregate.aggregateType(), aggregate.groupings(), remaining);
                        }
                    }
                    seenProjection.set((Object)Boolean.TRUE);
                    continue;
                }
                if (p instanceof Eval) {
                    Eval eval = (Eval)p;
                    List<Alias> list = remaining = (Boolean)seenProjection.get() != false ? PruneColumns.removeUnused(eval.fields(), used) : null;
                    if (remaining == null) continue;
                    if (remaining.isEmpty()) {
                        p = eval.child();
                        recheck = true;
                        continue;
                    }
                    p = new Eval(eval.source(), eval.child(), remaining);
                    continue;
                }
                if (!(p instanceof Project)) continue;
                seenProjection.set((Object)Boolean.TRUE);
            } while (recheck);
            used.addAll(p.references());
            return p;
        });
        return pl;
    }

    private static <N extends NamedExpression> List<N> removeUnused(List<N> named, AttributeSet used) {
        ArrayList<N> clone = new ArrayList<N>(named);
        ListIterator<N> it = clone.listIterator(clone.size());
        while (it.hasPrevious()) {
            NamedExpression prev = (NamedExpression)it.previous();
            if (!used.contains((Object)prev.toAttribute())) {
                it.remove();
                continue;
            }
            used.addAll(prev.references());
        }
        return clone.size() != named.size() ? clone : null;
    }
}

