/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.index;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.type.EsField;

public class EsIndex
implements Writeable {
    private final String name;
    private final Map<String, EsField> mapping;
    private final Map<String, IndexMode> indexNameWithModes;

    public EsIndex(String name, Map<String, EsField> mapping) {
        this(name, mapping, Map.of());
    }

    public EsIndex(String name, Map<String, EsField> mapping, Map<String, IndexMode> indexNameWithModes) {
        assert (name != null);
        assert (mapping != null);
        this.name = name;
        this.mapping = mapping;
        this.indexNameWithModes = indexNameWithModes;
    }

    public EsIndex(StreamInput in) throws IOException {
        this(in.readString(), in.readImmutableMap(StreamInput::readString, EsField::readFrom), EsIndex.readIndexNameWithModes(in));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name());
        out.writeMap(this.mapping(), (o, x) -> x.writeTo(out));
        EsIndex.writeIndexNameWithModes(this.indexNameWithModes, out);
    }

    private static Map<String, IndexMode> readIndexNameWithModes(StreamInput in) throws IOException {
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ADD_INDEX_MODE_CONCRETE_INDICES)) {
            return in.readMap(IndexMode::readFrom);
        }
        Set indices = (Set)in.readGenericValue();
        assert (indices != null);
        return indices.stream().collect(Collectors.toMap(e -> e, e -> IndexMode.STANDARD));
    }

    private static void writeIndexNameWithModes(Map<String, IndexMode> concreteIndices, StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ADD_INDEX_MODE_CONCRETE_INDICES)) {
            out.writeMap(concreteIndices, (o, v) -> IndexMode.writeTo((IndexMode)v, (StreamOutput)out));
        } else {
            out.writeGenericValue(concreteIndices.keySet());
        }
    }

    public String name() {
        return this.name;
    }

    public Map<String, EsField> mapping() {
        return this.mapping;
    }

    public Map<String, IndexMode> indexNameWithModes() {
        return this.indexNameWithModes;
    }

    public Set<String> concreteIndices() {
        return this.indexNameWithModes.keySet();
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.mapping, this.indexNameWithModes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EsIndex other = (EsIndex)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.mapping, other.mapping) && Objects.equals(this.indexNameWithModes, other.indexNameWithModes);
    }
}

