/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.util;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import org.elasticsearch.Build;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.util.DelayEvaluator;

public class Delay
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Delay", Delay::new);

    public Delay(Source source, @Param(name="ms", type={"time_duration"}, description="For how long") Expression ms) {
        super(source, ms);
    }

    private Delay(StreamInput in) throws IOException {
        super(in);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Delay(this.source(), newChildren.get(0));
    }

    public String getWriteableName() {
        return Delay.ENTRY.name;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isType((Expression)this.field(), t -> t == DataType.TIME_DURATION, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"time_duration"});
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Delay::new, (Object)this.field());
    }

    @Override
    public boolean foldable() {
        return false;
    }

    @Override
    public Object fold() {
        return null;
    }

    private long msValue() {
        if (!this.field().foldable()) {
            throw new IllegalArgumentException("function [" + this.sourceText() + "] has invalid argument [" + this.field().sourceText() + "]");
        }
        Object ms = this.field().fold();
        if (ms instanceof Duration) {
            Duration duration = (Duration)ms;
            return duration.toMillis();
        }
        return ((Number)ms).longValue();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return new DelayEvaluator.Factory(this.source(), this.msValue());
    }

    static boolean process(long ms) {
        if (Build.current().isSnapshot()) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException e) {
                return true;
            }
        } else {
            throw new IllegalArgumentException("Delay function is only available in snapshot builds");
        }
        return true;
    }
}

