/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.nulls;

import java.io.IOException;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class Coalesce
extends EsqlScalarFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Coalesce", Coalesce::new);
    private DataType dataType;

    @FunctionInfo(returnType={"boolean", "cartesian_point", "cartesian_shape", "date_nanos", "date", "geo_point", "geo_shape", "integer", "ip", "keyword", "long", "version"}, description="Returns the first of its arguments that is not null. If all arguments are null, it returns `null`.", examples={@Example(file="null", tag="coalesce")})
    public Coalesce(Source source, @Param(name="first", type={"boolean", "cartesian_point", "cartesian_shape", "date_nanos", "date", "geo_point", "geo_shape", "integer", "ip", "keyword", "long", "text", "version"}, description="Expression to evaluate.") Expression first, @Param(name="rest", type={"boolean", "cartesian_point", "cartesian_shape", "date_nanos", "date", "geo_point", "geo_shape", "integer", "ip", "keyword", "long", "text", "version"}, description="Other expression to evaluate.", optional=true) List<Expression> rest) {
        super(source, Stream.concat(Stream.of(first), rest.stream()).toList());
    }

    private Coalesce(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), in.readNamedWriteableCollectionAsList(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.children().get(0));
        out.writeNamedWriteableCollection(this.children().subList(1, this.children().size()));
    }

    public String getWriteableName() {
        return Coalesce.ENTRY.name;
    }

    public DataType dataType() {
        if (this.dataType == null) {
            this.resolveType();
        }
        return this.dataType;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        for (int position = 0; position < this.children().size(); ++position) {
            if (this.dataType == null || this.dataType == DataType.NULL) {
                this.dataType = ((Expression)this.children().get(position)).dataType().noText();
                continue;
            }
            Expression.TypeResolution resolution = TypeResolutions.isType((Expression)((Expression)this.children().get(position)), t -> t.noText() == this.dataType, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)position), (String[])new String[]{this.dataType.typeName()});
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public Nullability nullable() {
        for (Expression c : this.children()) {
            if (c.nullable() != Nullability.FALSE) continue;
            return Nullability.FALSE;
        }
        return Nullability.UNKNOWN;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Coalesce(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Coalesce::new, (Object)((Expression)this.children().get(0)), this.children().subList(1, this.children().size()));
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        final List<EvalOperator.ExpressionEvaluator.Factory> childEvaluators = this.children().stream().map(toEvaluator::apply).toList();
        return new EvalOperator.ExpressionEvaluator.Factory(){

            public EvalOperator.ExpressionEvaluator get(DriverContext context) {
                return new CoalesceEvaluator(context, PlannerUtils.toElementType(Coalesce.this.dataType()), childEvaluators.stream().map(x -> x.get(context)).toList());
            }

            public String toString() {
                return "CoalesceEvaluator[values=" + String.valueOf(childEvaluators) + "]";
            }
        };
    }

    private record CoalesceEvaluator(DriverContext driverContext, ElementType resultType, List<EvalOperator.ExpressionEvaluator> evaluators) implements EvalOperator.ExpressionEvaluator
    {
        public Block eval(Page page) {
            int positionCount = page.getPositionCount();
            try (Block.Builder result = this.resultType.newBlockBuilder(positionCount, this.driverContext.blockFactory());){
                block16: for (int p = 0; p < positionCount; ++p) {
                    int[] positions = new int[]{p};
                    Page limited = new Page(1, (Block[])IntStream.range(0, page.getBlockCount()).mapToObj(b -> page.getBlock(b).filter(positions)).toArray(Block[]::new));
                    try (Releasable ignored = () -> ((Page)limited).releaseBlocks();){
                        for (EvalOperator.ExpressionEvaluator eval : this.evaluators) {
                            Block block = eval.eval(limited);
                            try {
                                if (block.isNull(0)) continue;
                                result.copyFrom(block, 0, 1);
                                continue block16;
                            }
                            finally {
                                if (block == null) continue;
                                block.close();
                            }
                        }
                        result.appendNull();
                        continue;
                    }
                }
                Block block = result.build();
                return block;
            }
        }

        @Override
        public String toString() {
            return "CoalesceEvaluator[values=" + String.valueOf(this.evaluators) + "]";
        }

        public void close() {
            Releasables.closeExpectNoException(() -> Releasables.close(this.evaluators));
        }
    }
}

