/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMax;

public final class MvMaxBooleanEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    public MvMaxBooleanEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
    }

    @Override
    public String name() {
        return "MvMax";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNullable(fieldVal);
        }
        BooleanBlock v = (BooleanBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BooleanBlock.Builder builder = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                boolean value = v.getBoolean(first);
                for (int i = first + 1; i < end; ++i) {
                    boolean next = v.getBoolean(i);
                    value = MvMax.process(value, next);
                }
                boolean result = value;
                builder.appendBoolean(result);
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNotNullable(fieldVal);
        }
        BooleanBlock v = (BooleanBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BooleanVector.FixedBuilder builder = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                boolean value = v.getBoolean(first);
                for (int i = first + 1; i < end; ++i) {
                    boolean next = v.getBoolean(i);
                    value = MvMax.process(value, next);
                }
                boolean result = value;
                builder.appendBoolean(result);
            }
            BooleanBlock booleanBlock = builder.build().asBlock();
            return booleanBlock;
        }
    }

    private Block evalAscendingNullable(Block fieldVal) {
        BooleanBlock v = (BooleanBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BooleanBlock.Builder builder = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int idx = MvMax.ascendingIndex(valueCount);
                boolean result = v.getBoolean(first + idx);
                builder.appendBoolean(result);
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    private Block evalAscendingNotNullable(Block fieldVal) {
        BooleanBlock v = (BooleanBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BooleanVector.FixedBuilder builder = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int idx = MvMax.ascendingIndex(valueCount);
                boolean result = v.getBoolean(first + idx);
                builder.appendBoolean(result);
            }
            BooleanBlock booleanBlock = builder.build().asBlock();
            return booleanBlock;
        }
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvMaxBooleanEvaluator get(DriverContext context) {
            return new MvMaxBooleanEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvMax[field=" + String.valueOf(this.field) + "]";
        }
    }
}

