/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AbsDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AbsIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AbsLongEvaluator;

public class Abs
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Abs", Abs::new);

    @FunctionInfo(returnType={"double", "integer", "long", "unsigned_long"}, description="Returns the absolute value.", examples={@Example(file="math", tag="abs"), @Example(file="math", tag="abs-employees")})
    public Abs(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}, description="Numeric expression. If `null`, the function returns `null`.") Expression n) {
        super(source, n);
    }

    private Abs(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Abs.ENTRY.name;
    }

    static double process(double fieldVal) {
        return Math.abs(fieldVal);
    }

    static long process(long fieldVal) {
        return Math.absExact(fieldVal);
    }

    static int process(int fieldVal) {
        return Math.absExact(fieldVal);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory field = toEvaluator.apply(this.field());
        if (this.dataType() == DataType.DOUBLE) {
            return new AbsDoubleEvaluator.Factory(this.source(), field);
        }
        if (this.dataType() == DataType.UNSIGNED_LONG) {
            return field;
        }
        if (this.dataType() == DataType.LONG) {
            return new AbsLongEvaluator.Factory(this.source(), field);
        }
        if (this.dataType() == DataType.INTEGER) {
            return new AbsIntEvaluator.Factory(this.source(), field);
        }
        throw EsqlIllegalArgumentException.illegalDataType(this.dataType());
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new Abs(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Abs::new, (Object)this.field());
    }
}

