/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToVersionFromStringEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToVersion
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToVersion", ToVersion::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.VERSION, (fieldEval, source) -> fieldEval), Map.entry(DataType.KEYWORD, ToVersionFromStringEvaluator.Factory::new), Map.entry(DataType.TEXT, ToVersionFromStringEvaluator.Factory::new), Map.entry(DataType.SEMANTIC_TEXT, ToVersionFromStringEvaluator.Factory::new));

    @FunctionInfo(returnType={"version"}, description="Converts an input string to a version value.", examples={@Example(file="version", tag="to_version")})
    public ToVersion(Source source, @Param(name="field", type={"keyword", "text", "version"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression v) {
        super(source, v);
    }

    private ToVersion(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToVersion.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.VERSION;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToVersion(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToVersion::new, (Object)this.field());
    }

    static BytesRef fromKeyword(BytesRef asString) {
        return EsqlDataTypeConverter.stringToVersion(asString);
    }
}

