/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class QueryString
extends FullTextFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "QStr", QueryString::new);

    @FunctionInfo(returnType={"boolean"}, preview=true, description="Performs a query string query. Returns true if the provided query string matches the row.", examples={@Example(file="qstr-function", tag="qstr-with-field")})
    public QueryString(Source source, @Param(name="query", type={"keyword", "text"}, description="Query string in Lucene query string format.") Expression queryString) {
        super(source, queryString, List.of(queryString));
    }

    private QueryString(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.query());
    }

    public String getWriteableName() {
        return QueryString.ENTRY.name;
    }

    public String functionName() {
        return "QSTR";
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new QueryString(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, QueryString::new, (Object)this.query());
    }
}

