/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.retriever;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.SuggestingErrorOnUnknown;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.xcontent.AbstractObjectParser;
import org.elasticsearch.xcontent.FilterXContentParserWrapper;
import org.elasticsearch.xcontent.NamedObjectNotFoundException;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;

public abstract class RetrieverBuilder
implements Rewriteable<RetrieverBuilder>,
ToXContent {
    public static final NodeFeature RETRIEVERS_SUPPORTED = new NodeFeature("retrievers_supported");
    public static final ParseField PRE_FILTER_FIELD = new ParseField("filter", new String[0]);
    public static final ParseField MIN_SCORE_FIELD = new ParseField("min_score", new String[0]);
    public static final ParseField NAME_FIELD = new ParseField("_name", new String[0]);
    protected List<QueryBuilder> preFilterQueryBuilders = new ArrayList<QueryBuilder>();
    protected String retrieverName;
    protected Float minScore;
    protected RankDoc[] rankDocs = null;

    protected static void declareBaseParserFields(String name, AbstractObjectParser<? extends RetrieverBuilder, RetrieverParserContext> parser) {
        parser.declareObjectArray((r, v) -> {
            r.preFilterQueryBuilders = v;
        }, (p, c) -> AbstractQueryBuilder.parseTopLevelQuery(p, c::trackQueryUsage), PRE_FILTER_FIELD);
        parser.declareString(RetrieverBuilder::retrieverName, NAME_FIELD);
        parser.declareFloat(RetrieverBuilder::minScore, MIN_SCORE_FIELD);
    }

    public RetrieverBuilder retrieverName(String retrieverName) {
        this.retrieverName = retrieverName;
        return this;
    }

    public RetrieverBuilder minScore(Float minScore) {
        this.minScore = minScore;
        return this;
    }

    public static RetrieverBuilder parseTopLevelRetrieverBuilder(XContentParser parser, RetrieverParserContext context) throws IOException {
        parser = new FilterXContentParserWrapper((XContentParser)parser){

            public <T> T namedObject(Class<T> categoryClass, String name, Object context) throws IOException {
                return (T)this.getXContentRegistry().parseNamedObject(categoryClass, name, (XContentParser)this, context);
            }
        };
        return RetrieverBuilder.parseInnerRetrieverBuilder(parser, context);
    }

    protected static RetrieverBuilder parseInnerRetrieverBuilder(XContentParser parser, RetrieverParserContext context) throws IOException {
        RetrieverBuilder retrieverBuilder;
        Objects.requireNonNull(context);
        if (parser.currentToken() != XContentParser.Token.START_OBJECT && parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "retriever malformed, must start with [" + String.valueOf(XContentParser.Token.START_OBJECT) + "]", new Object[0]);
        }
        if (parser.nextToken() == XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "retriever malformed, empty clause found", new Object[0]);
        }
        if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "retriever malformed, no field after [" + String.valueOf(XContentParser.Token.START_OBJECT) + "]", new Object[0]);
        }
        String retrieverName = parser.currentName();
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[" + retrieverName + "] retriever malformed, no [" + String.valueOf(XContentParser.Token.START_OBJECT) + "] after retriever name", new Object[0]);
        }
        try {
            retrieverBuilder = (RetrieverBuilder)parser.namedObject(RetrieverBuilder.class, retrieverName, (Object)context);
        }
        catch (NamedObjectNotFoundException nonfe) {
            String message = String.format(Locale.ROOT, "unknown retriever [%s]%s", retrieverName, SuggestingErrorOnUnknown.suggest(retrieverName, nonfe.getCandidates()));
            throw new ParsingException(new XContentLocation(nonfe.getLineNumber(), nonfe.getColumnNumber()), message, nonfe, new Object[0]);
        }
        context.trackRetrieverUsage(retrieverName);
        if (parser.currentToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[" + retrieverName + "] malformed retriever, expected [" + String.valueOf(XContentParser.Token.END_OBJECT) + "] but found [" + String.valueOf(parser.currentToken()) + "]", new Object[0]);
        }
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[" + retrieverName + "] malformed retriever, expected [" + String.valueOf(XContentParser.Token.END_OBJECT) + "] but found [" + String.valueOf(parser.currentToken()) + "]", new Object[0]);
        }
        return retrieverBuilder;
    }

    public boolean isCompound() {
        return false;
    }

    protected final List<QueryBuilder> rewritePreFilters(QueryRewriteContext ctx) throws IOException {
        ArrayList<QueryBuilder> newFilters = new ArrayList<QueryBuilder>(this.preFilterQueryBuilders.size());
        boolean changed = false;
        for (QueryBuilder filter : this.preFilterQueryBuilders) {
            QueryBuilder newFilter;
            changed |= filter != (newFilter = filter.rewrite(ctx));
            newFilters.add(newFilter);
        }
        if (changed) {
            return newFilters;
        }
        return this.preFilterQueryBuilders;
    }

    public abstract QueryBuilder topDocsQuery();

    public QueryBuilder explainQuery() {
        return this.topDocsQuery();
    }

    public Float minScore() {
        return this.minScore;
    }

    public void setRankDocs(RankDoc[] rankDocs) {
        this.rankDocs = rankDocs;
    }

    public RankDoc[] getRankDocs() {
        return this.rankDocs;
    }

    public List<QueryBuilder> getPreFilterQueryBuilders() {
        return this.preFilterQueryBuilders;
    }

    @Override
    public RetrieverBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        return this;
    }

    public abstract void extractToSearchSourceBuilder(SearchSourceBuilder var1, boolean var2);

    public ActionRequestValidationException validate(SearchSourceBuilder source, ActionRequestValidationException validationException, boolean isScroll, boolean allowPartialSearchResults) {
        return validationException;
    }

    public abstract String getName();

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(this.getName());
        if (!this.preFilterQueryBuilders.isEmpty()) {
            builder.field(PRE_FILTER_FIELD.getPreferredName(), this.preFilterQueryBuilders);
        }
        if (this.minScore != null) {
            builder.field(MIN_SCORE_FIELD.getPreferredName(), this.minScore);
        }
        if (this.retrieverName != null) {
            builder.field(NAME_FIELD.getPreferredName(), this.retrieverName);
        }
        this.doToXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    protected abstract void doToXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public boolean isFragment() {
        return false;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrieverBuilder that = (RetrieverBuilder)o;
        return Objects.equals(this.preFilterQueryBuilders, that.preFilterQueryBuilders) && Objects.equals(this.minScore, that.minScore) && this.doEquals(o);
    }

    protected abstract boolean doEquals(Object var1);

    public final int hashCode() {
        return Objects.hash(this.getClass(), this.preFilterQueryBuilders, this.minScore, this.doHashCode());
    }

    protected abstract int doHashCode();

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public String retrieverName() {
        return this.retrieverName;
    }
}

