/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceFilter;

public final class FetchSourcePhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(final FetchContext fetchContext) {
        final FetchSourceContext fetchSourceContext = fetchContext.fetchSourceContext();
        if (fetchSourceContext == null || !fetchSourceContext.fetchSource()) {
            return null;
        }
        assert (fetchSourceContext.fetchSource());
        final SourceFilter sourceFilter = fetchSourceContext.filter();
        final boolean filterExcludesAll = sourceFilter.excludesAll();
        return new FetchSubPhaseProcessor(){
            private int fastPath;

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
            }

            @Override
            public StoredFieldsSpec storedFieldsSpec() {
                return StoredFieldsSpec.NEEDS_SOURCE;
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) {
                String index = fetchContext.getIndexName();
                if (!fetchContext.getSearchExecutionContext().isSourceEnabled()) {
                    if (fetchSourceContext.hasFilter()) {
                        throw new IllegalArgumentException("unable to fetch fields from _source field: _source is disabled in the mappings for index [" + index + "]");
                    }
                    return;
                }
                this.hitExecute(fetchSourceContext, hitContext);
            }

            private void hitExecute(FetchSourceContext fetchSourceContext2, FetchSubPhase.HitContext hitContext) {
                boolean nestedHit = hitContext.hit().getNestedIdentity() != null;
                Source source = hitContext.source();
                if (!nestedHit && !fetchSourceContext2.hasFilter()) {
                    hitContext.hit().sourceRef(source.internalSourceRef());
                    ++this.fastPath;
                    return;
                }
                source = filterExcludesAll ? Source.empty(source.sourceContentType()) : source.filter(sourceFilter);
                if (nestedHit) {
                    source = FetchSourcePhase.extractNested(source, hitContext.hit().getNestedIdentity());
                }
                hitContext.hit().sourceRef(source.internalSourceRef());
            }

            @Override
            public Map<String, Object> getDebugInfo() {
                return Map.of("fast_path", this.fastPath);
            }
        };
    }

    private static Source extractNested(Source in, SearchHit.NestedIdentity nestedIdentity) {
        Map sourceMap = in.source();
        while (nestedIdentity != null) {
            if ((sourceMap = (Map)sourceMap.get(nestedIdentity.getField().string())) == null) {
                return Source.empty(in.sourceContentType());
            }
            nestedIdentity = nestedIdentity.getChild();
        }
        return Source.fromMap(sourceMap, in.sourceContentType());
    }
}

