/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.util.Iterator;

public interface MultiDenseVector {
    public static final MultiDenseVector EMPTY = new MultiDenseVector(){
        public static final String MISSING_VECTOR_FIELD_MESSAGE = "Multi Dense vector value missing for a field, use isEmpty() to check for a missing vector value";

        @Override
        public Iterator<float[]> getVectors() {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public float[] getMagnitudes() {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int getDims() {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public int size() {
            return 0;
        }
    };

    default public void checkDimensions(int qvDims) {
        MultiDenseVector.checkDimensions(this.getDims(), qvDims);
    }

    public Iterator<float[]> getVectors();

    public float[] getMagnitudes();

    public boolean isEmpty();

    public int getDims();

    public int size();

    public static void checkDimensions(int dvDims, int qvDims) {
        if (dvDims != qvDims) {
            throw new IllegalArgumentException("The query vector has a different number of dimensions [" + qvDims + "] than the document vectors [" + dvDims + "].");
        }
    }

    private static String badQueryVectorType(Object queryVector) {
        return "Cannot use vector [" + String.valueOf(queryVector) + "] with class [" + queryVector.getClass().getName() + "] as query vector";
    }
}

