/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.rest.AbstractRestChannel;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class RestResponse
implements Releasable {
    public static final String TEXT_CONTENT_TYPE = "text/plain; charset=UTF-8";
    public static final Set<String> RESPONSE_PARAMS = Set.of("error_trace");
    static final String STATUS = "status";
    private static final Logger SUPPRESSED_ERROR_LOGGER = LogManager.getLogger((String)"rest.suppressed");
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(AbstractRestChannel.class);
    private final RestStatus status;
    @Nullable
    private final BytesReference content;
    @Nullable
    private final ChunkedRestResponseBodyPart chunkedResponseBody;
    private final String responseMediaType;
    private Map<String, List<String>> customHeaders;
    @Nullable
    private final Releasable releasable;

    public RestResponse(RestStatus status, XContentBuilder builder) {
        this(status, builder.getResponseContentTypeString(), BytesReference.bytes(builder));
    }

    public RestResponse(RestStatus status, String content) {
        this(status, TEXT_CONTENT_TYPE, new BytesArray(content));
    }

    public RestResponse(RestStatus status, String responseMediaType, String content) {
        this(status, responseMediaType, new BytesArray(content));
    }

    public RestResponse(RestStatus status, String responseMediaType, BytesReference content) {
        this(status, responseMediaType, content, null, null);
    }

    private RestResponse(RestStatus status, String responseMediaType, BytesReference content, @Nullable Releasable releasable) {
        this(status, responseMediaType, content, null, releasable);
    }

    public static RestResponse chunked(RestStatus restStatus, ChunkedRestResponseBodyPart content, @Nullable Releasable releasable) {
        if (content.isPartComplete()) {
            assert (content.isLastPart()) : "response with continuations must have at least one (possibly-empty) chunk in each part";
            return new RestResponse(restStatus, content.getResponseContentTypeString(), BytesArray.EMPTY, releasable);
        }
        return new RestResponse(restStatus, content.getResponseContentTypeString(), null, content, releasable);
    }

    private RestResponse(RestStatus status, String responseMediaType, @Nullable BytesReference content, @Nullable ChunkedRestResponseBodyPart chunkedResponseBody, @Nullable Releasable releasable) {
        this.status = status;
        this.content = content;
        this.responseMediaType = responseMediaType;
        this.chunkedResponseBody = chunkedResponseBody;
        this.releasable = releasable;
        assert (content == null != (chunkedResponseBody == null));
    }

    public RestResponse(RestChannel channel, Exception e) throws IOException {
        this(channel, ExceptionsHelper.status(e), e);
    }

    public RestResponse(RestChannel channel, RestStatus status, Exception e) throws IOException {
        this.status = status;
        RestRequest params = channel.request();
        if (e != null) {
            Supplier messageSupplier = () -> String.format(Locale.ROOT, "path: %s, params: %s, status: %d", channel.request().rawPath(), channel.request().params(), status.getStatus());
            if (status.getStatus() < 500 || ExceptionsHelper.isNodeOrShardUnavailableTypeException(e)) {
                SUPPRESSED_ERROR_LOGGER.debug(messageSupplier, (Throwable)e);
            } else {
                SUPPRESSED_ERROR_LOGGER.warn(messageSupplier, (Throwable)e);
            }
        }
        if (params.paramAsBoolean("error_trace", false) && status != RestStatus.UNAUTHORIZED) {
            params = new ToXContent.DelegatingMapParams(Collections.singletonMap("rest.exception.stacktrace.skip", "false"), (ToXContent.Params)params);
        }
        if (!channel.detailedErrorsEnabled()) {
            deprecationLogger.warn(DeprecationCategory.API, "http_detailed_errors", "The JSON format of non-detailed errors will change in Elasticsearch 9.0 to match the JSON structure used for detailed errors. To keep using the existing format, use the V8 REST API.", new Object[0]);
        }
        try (XContentBuilder builder = channel.newErrorBuilder();){
            RestResponse.build(builder, params, status, channel.detailedErrorsEnabled(), e);
            this.content = BytesReference.bytes(builder);
            this.responseMediaType = builder.getResponseContentTypeString();
        }
        if (e instanceof ElasticsearchException) {
            this.copyHeaders((ElasticsearchException)e);
        }
        this.chunkedResponseBody = null;
        this.releasable = null;
    }

    public String contentType() {
        return this.responseMediaType;
    }

    @Nullable
    public BytesReference content() {
        return this.content;
    }

    @Nullable
    public ChunkedRestResponseBodyPart chunkedContent() {
        return this.chunkedResponseBody;
    }

    public boolean isChunked() {
        return this.chunkedResponseBody != null;
    }

    public RestStatus status() {
        return this.status;
    }

    private static void build(XContentBuilder builder, ToXContent.Params params, RestStatus status, boolean detailedErrorsEnabled, Exception e) throws IOException {
        builder.startObject();
        ElasticsearchException.generateFailureXContent(builder, params, e, detailedErrorsEnabled);
        builder.field(STATUS, status.getStatus());
        builder.endObject();
    }

    static RestResponse createSimpleErrorResponse(RestChannel channel, RestStatus status, String errorMessage) throws IOException {
        return new RestResponse(status, channel.newErrorBuilder().startObject().field("error", errorMessage).field(STATUS, status.getStatus()).endObject());
    }

    public void copyHeaders(ElasticsearchException ex) {
        Set<String> headerKeySet = ex.getHeaderKeys();
        if (this.customHeaders == null) {
            this.customHeaders = Maps.newMapWithExpectedSize(headerKeySet.size());
        }
        for (String key : headerKeySet) {
            this.customHeaders.computeIfAbsent(key, k -> new ArrayList()).addAll(ex.getHeader(key));
        }
    }

    public void addHeader(String name, String value) {
        if (this.customHeaders == null) {
            this.customHeaders = Maps.newMapWithExpectedSize(2);
        }
        this.customHeaders.computeIfAbsent(name, k -> new ArrayList()).add(value);
    }

    public Map<String, List<String>> getHeaders() {
        return Objects.requireNonNullElse(this.customHeaders, Map.of());
    }

    public Map<String, List<String>> filterHeaders(Map<String, List<String>> headers) {
        if (this.status() == RestStatus.UNAUTHORIZED || this.status() == RestStatus.FORBIDDEN) {
            if (headers.containsKey("Warning")) {
                headers = Maps.copyMapWithRemovedEntry(headers, "Warning");
            }
            if (headers.containsKey("X-elastic-product")) {
                headers = Maps.copyMapWithRemovedEntry(headers, "X-elastic-product");
            }
        }
        return headers;
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.releasable);
    }
}

